/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import org.shaded.slf4j.Logger;
import org.shaded.slf4j.LoggerFactory;
import oshi.hardware.NetworkIF;
import oshi.hardware.common.AbstractNetworks;
import oshi.jna.platform.windows.IPHlpAPI;

public class WindowsNetworks
extends AbstractNetworks {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsNetworks.class);

    @Override
    public void updateNetworkStats(NetworkIF netIF) {
        IPHlpAPI.MIB_IFROW ifRow = new IPHlpAPI.MIB_IFROW();
        ifRow.dwIndex = netIF.getNetworkInterface().getIndex();
        if (0 != IPHlpAPI.INSTANCE.GetIfEntry(ifRow)) {
            LOG.error("Failed to retrieve data for interface {}, {}", (Object)netIF.getNetworkInterface().getIndex(), (Object)netIF.getName());
            return;
        }
        netIF.setBytesSent(ifRow.dwOutOctets);
        netIF.setBytesRecv(ifRow.dwInOctets);
        netIF.setPacketsSent(ifRow.dwOutUcastPkts);
        netIF.setPacketsRecv(ifRow.dwInUcastPkts);
        netIF.setSpeed(ifRow.dwSpeed);
    }
}

