/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.common;

import javax.shaded.json.Json;
import javax.shaded.json.JsonBuilderFactory;
import javax.shaded.json.JsonObject;
import oshi.json.NullAwareJsonObjectBuilder;
import oshi.software.os.OSProcess;

public class AbstractProcess
implements OSProcess {
    private static final long serialVersionUID = 1L;
    private JsonBuilderFactory jsonFactory = Json.createBuilderFactory(null);
    protected String name;
    protected String path;
    protected OSProcess.State state;
    protected int processID;
    protected int parentProcessID;
    protected int threadCount;
    protected int priority;
    protected long virtualSize;
    protected long residentSetSize;
    protected long kernelTime;
    protected long userTime;
    protected long startTime;
    protected long upTime;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public OSProcess.State getState() {
        return this.state;
    }

    @Override
    public int getProcessID() {
        return this.processID;
    }

    @Override
    public int getParentProcessID() {
        return this.parentProcessID;
    }

    @Override
    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public long getVirtualSize() {
        return this.virtualSize;
    }

    @Override
    public long getResidentSetSize() {
        return this.residentSetSize;
    }

    @Override
    public long getKernelTime() {
        return this.kernelTime;
    }

    @Override
    public long getUserTime() {
        return this.userTime;
    }

    @Override
    public long getUpTime() {
        if (this.upTime < this.kernelTime + this.userTime) {
            return this.kernelTime + this.userTime;
        }
        return this.upTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public JsonObject toJSON() {
        return NullAwareJsonObjectBuilder.wrap(this.jsonFactory.createObjectBuilder()).add("name", this.getName()).add("path", this.getPath()).add("state", this.getState().name()).add("processID", this.getProcessID()).add("parentProcessID", this.getParentProcessID()).add("threadCount", this.getThreadCount()).add("priority", this.getPriority()).add("virtualSize", this.getVirtualSize()).add("residentSetSize", this.getResidentSetSize()).add("kernelTime", this.getKernelTime()).add("userTime", this.getUserTime()).add("upTime", this.getUpTime()).add("startTime", this.getStartTime()).build();
    }
}

