/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.mac;

import org.shaded.slf4j.Logger;
import org.shaded.slf4j.LoggerFactory;
import oshi.software.common.AbstractOSVersionInfoEx;
import oshi.util.platform.mac.SysctlUtil;

public class MacOSVersionInfoEx
extends AbstractOSVersionInfoEx {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MacOSVersionInfoEx.class);

    public MacOSVersionInfoEx() {
        this.setVersion(System.getProperty("os.version"));
        this.setCodeName(this.parseCodeName());
        this.setBuildNumber(SysctlUtil.sysctl("kern.osversion", ""));
    }

    private String parseCodeName() {
        String[] versionSplit = this.getVersion().split("\\.");
        if (versionSplit.length > 1 && versionSplit[0].equals("10")) {
            switch (Integer.parseInt(versionSplit[1])) {
                case 12: {
                    return "Sierra";
                }
                case 11: {
                    return "El Capitan";
                }
                case 10: {
                    return "Yosemite";
                }
                case 9: {
                    return "Mavericks";
                }
                case 8: {
                    return "Mountain Lion";
                }
                case 7: {
                    return "Lion";
                }
                case 6: {
                    return "Snow Leopard";
                }
                case 5: {
                    return "Leopard";
                }
                case 4: {
                    return "Tiger";
                }
                case 3: {
                    return "Panther";
                }
                case 2: {
                    return "Jaguar";
                }
                case 1: {
                    return "Puma";
                }
                case 0: {
                    return "Cheetah";
                }
            }
        }
        LOG.warn("Unable to parse version {} to a codename.", (Object)this.getVersion());
        return "";
    }
}

