/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.mac;

import oshi.software.common.AbstractProcess;
import oshi.software.os.OSProcess;

public class MacProcess
extends AbstractProcess {
    private static final long serialVersionUID = 1L;
    private static final int SSLEEP = 1;
    private static final int SWAIT = 2;
    private static final int SRUN = 3;
    private static final int SIDL = 4;
    private static final int SZOMB = 5;
    private static final int SSTOP = 6;

    public MacProcess(String name, String path, int osXState, int processID, int parentProcessID, int threadCount, int priority, long virtualSize, long residentSetSize, long kernelTime, long userTime, long startTime, long now) {
        this.name = name;
        this.path = path;
        switch (osXState) {
            case 1: {
                this.state = OSProcess.State.SLEEPING;
                break;
            }
            case 2: {
                this.state = OSProcess.State.WAITING;
                break;
            }
            case 3: {
                this.state = OSProcess.State.RUNNING;
                break;
            }
            case 4: {
                this.state = OSProcess.State.NEW;
                break;
            }
            case 5: {
                this.state = OSProcess.State.ZOMBIE;
                break;
            }
            case 6: {
                this.state = OSProcess.State.STOPPED;
                break;
            }
            default: {
                this.state = OSProcess.State.OTHER;
            }
        }
        this.processID = processID;
        this.parentProcessID = parentProcessID;
        this.threadCount = threadCount;
        this.priority = priority;
        this.virtualSize = virtualSize;
        this.residentSetSize = residentSetSize;
        this.kernelTime = kernelTime;
        this.userTime = userTime;
        this.startTime = startTime;
        this.upTime = now - startTime;
    }
}

