/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinReg;
import java.util.ArrayList;
import org.shaded.slf4j.Logger;
import org.shaded.slf4j.LoggerFactory;
import oshi.software.common.AbstractOSVersionInfoEx;

public class WindowsOSVersionInfoEx
extends AbstractOSVersionInfoEx {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsOSVersionInfoEx.class);
    private WinNT.OSVERSIONINFOEX versionInfo = null;

    public WindowsOSVersionInfoEx() {
        this.versionInfo = new WinNT.OSVERSIONINFOEX();
        if (!Kernel32.INSTANCE.GetVersionEx(this.versionInfo)) {
            LOG.error("Failed to Initialize OSVersionInfoEx. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
        }
        this.init();
        LOG.debug("Initialized OSVersionInfoEx");
    }

    public WindowsOSVersionInfoEx(WinNT.OSVERSIONINFOEX versionInfo) {
        this.versionInfo = versionInfo;
        this.init();
    }

    private void init() {
        this.setVersion(this.parseVersion());
        this.setCodeName(this.parseCodeName());
        if (this.versionInfo == null) {
            LOG.warn("OSVersionInfoEx not initialized. No build number available");
            this.setBuildNumber("");
            return;
        }
        this.setBuildNumber(this.versionInfo.dwBuildNumber.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String parseVersion() {
        if (this.versionInfo == null) {
            LOG.warn("OSVersionInfoEx not initialized. No version data available");
            return System.getProperty("os.version");
        }
        String version = null;
        if (this.getPlatformId() == 2) {
            boolean ntWorkstation;
            boolean bl = ntWorkstation = this.getProductType() == 1;
            if (this.getMajor() == 10 && this.getMinor() == 0 && ntWorkstation) {
                version = "10";
            } else if (this.getMajor() == 10 && this.getMinor() == 0 && !ntWorkstation) {
                version = "Server 2016";
            } else if (this.getMajor() == 6 && this.getMinor() == 3 && ntWorkstation) {
                version = "8.1";
            } else if (this.getMajor() == 6 && this.getMinor() == 3 && !ntWorkstation) {
                version = "Server 2012 R2";
            } else if (this.getMajor() == 6 && this.getMinor() == 2 && ntWorkstation) {
                version = "8";
            } else if (this.getMajor() == 6 && this.getMinor() == 2 && !ntWorkstation) {
                version = "Server 2012";
            } else if (this.getMajor() == 6 && this.getMinor() == 1 && ntWorkstation) {
                version = "7";
            } else if (this.getMajor() == 6 && this.getMinor() == 1 && !ntWorkstation) {
                version = "Server 2008 R2";
            } else if (this.getMajor() == 6 && this.getMinor() == 0 && !ntWorkstation) {
                version = "Server 2008";
            } else if (this.getMajor() == 6 && this.getMinor() == 0 && ntWorkstation) {
                version = "Vista";
            } else if (this.getMajor() == 5 && this.getMinor() == 2 && !ntWorkstation) {
                version = User32.INSTANCE.GetSystemMetrics(89) != 0 ? "Server 2003" : "Server 2003 R2";
            } else if (this.getMajor() == 5 && this.getMinor() == 2 && ntWorkstation) {
                version = "XP";
            } else if (this.getMajor() == 5 && this.getMinor() == 1) {
                version = "XP";
            } else if (this.getMajor() == 5 && this.getMinor() == 0) {
                version = "2000";
            } else {
                if (this.getMajor() != 4) throw new RuntimeException("Unsupported Windows NT version: " + this.versionInfo.toString());
                version = "NT 4";
                if ("Service Pack 6".equals(this.getServicePack()) && Advapi32Util.registryKeyExists(WinReg.HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Hotfix\\Q246009")) {
                    return "NT4 SP6a";
                }
            }
            if (this.versionInfo.wServicePackMajor.intValue() <= 0) return version;
            return version + " SP" + this.versionInfo.wServicePackMajor.intValue();
        }
        if (this.getPlatformId() != 1) throw new RuntimeException("Unsupported Windows platform: " + this.versionInfo.toString());
        if (this.getMajor() == 4 && this.getMinor() == 90) {
            return "ME";
        }
        if (this.getMajor() == 4 && this.getMinor() == 10) {
            if (this.versionInfo.szCSDVersion[1] != 'A') return "98";
            return "98 SE";
        }
        if (this.getMajor() != 4) throw new RuntimeException("Unsupported Windows 9x version: " + this.versionInfo.toString());
        if (this.getMinor() != 0) throw new RuntimeException("Unsupported Windows 9x version: " + this.versionInfo.toString());
        if (this.versionInfo.szCSDVersion[1] == 'C') return "95 OSR2";
        if (this.versionInfo.szCSDVersion[1] != 'B') return "95";
        return "95 OSR2";
    }

    private int getPlatformId() {
        if (this.versionInfo == null) {
            LOG.warn("OSVersionInfoEx not initialized. No platform id available");
            return 0;
        }
        return this.versionInfo.dwPlatformId.intValue();
    }

    private byte getProductType() {
        if (this.versionInfo == null) {
            LOG.warn("OSVersionInfoEx not initialized. No product type available");
            return 0;
        }
        return this.versionInfo.wProductType;
    }

    private int getMajor() {
        if (this.versionInfo == null) {
            LOG.warn("OSVersionInfoEx not initialized. No version data available");
            return 0;
        }
        return this.versionInfo.dwMajorVersion.intValue();
    }

    private int getMinor() {
        if (this.versionInfo == null) {
            LOG.warn("OSVersionInfoEx not initialized. No version data available");
            return 0;
        }
        return this.versionInfo.dwMinorVersion.intValue();
    }

    private String getServicePack() {
        if (this.versionInfo == null) {
            LOG.warn("OSVersionInfoEx not initialized. No service pack data available");
            return "";
        }
        return Native.toString(this.versionInfo.szCSDVersion);
    }

    private String parseCodeName() {
        ArrayList<String> suites = new ArrayList<String>();
        int bitmask = this.getSuiteMask();
        if ((bitmask & 4) != 0) {
            suites.add("BackOffice");
        }
        if ((bitmask & 0x400) != 0) {
            suites.add("Web Edition");
        }
        if ((bitmask & 0x4000) != 0) {
            suites.add("Compute Cluster");
        }
        if ((bitmask & 0x80) != 0) {
            suites.add("Datacenter");
        }
        if ((bitmask & 2) != 0) {
            suites.add("Enterprise");
        }
        if ((bitmask & 0x200) != 0) {
            suites.add("Home");
        }
        if ((bitmask & 0x8000) != 0) {
            suites.add("Home Server");
        }
        String separator = "";
        StringBuilder sb = new StringBuilder();
        for (String s : suites) {
            sb.append(separator).append(s);
            separator = ",";
        }
        return sb.toString();
    }

    private int getSuiteMask() {
        if (this.versionInfo == null) {
            LOG.warn("OSVersionInfoEx not initialized. No suite mask data available");
            return 0;
        }
        return this.versionInfo.wSuiteMask.intValue();
    }
}

