/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.mac;

import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import org.shaded.slf4j.Logger;
import org.shaded.slf4j.LoggerFactory;
import oshi.jna.platform.mac.CoreFoundation;
import oshi.jna.platform.mac.IOKit;
import oshi.util.platform.mac.CfUtil;

public class IOKitUtil {
    private static final Logger LOG = LoggerFactory.getLogger(IOKitUtil.class);
    private static IOKit.MachPort masterPort = new IOKit.MachPort();

    private static int setMasterPort() {
        int result;
        if (masterPort.getValue() == 0 && (result = IOKit.INSTANCE.IOMasterPort(0, masterPort)) != 0) {
            LOG.error(String.format("Error: IOMasterPort() = %08x", result));
            return result;
        }
        return 0;
    }

    public static int getRoot() {
        if (IOKitUtil.setMasterPort() == 0) {
            int root = IOKit.INSTANCE.IORegistryGetRootEntry(masterPort.getValue());
            if (root == 0) {
                LOG.error("No IO Root found.");
            }
            return root;
        }
        return 0;
    }

    public static int getMatchingService(String serviceName) {
        if (IOKitUtil.setMasterPort() == 0) {
            int service = IOKit.INSTANCE.IOServiceGetMatchingService(masterPort.getValue(), IOKit.INSTANCE.IOServiceMatching(serviceName));
            if (service == 0) {
                LOG.error("No service found: {}", (Object)serviceName);
            }
            return service;
        }
        return 0;
    }

    public static int getMatchingServices(String serviceName, IntByReference serviceIterator) {
        int setMasterPort = IOKitUtil.setMasterPort();
        if (setMasterPort == 0) {
            return IOKit.INSTANCE.IOServiceGetMatchingServices(masterPort.getValue(), IOKit.INSTANCE.IOServiceMatching(serviceName), serviceIterator);
        }
        return setMasterPort;
    }

    public static int getMatchingServices(CoreFoundation.CFMutableDictionaryRef matchingDictionary, IntByReference serviceIterator) {
        int setMasterPort = IOKitUtil.setMasterPort();
        if (setMasterPort == 0) {
            return IOKit.INSTANCE.IOServiceGetMatchingServices(masterPort.getValue(), matchingDictionary, serviceIterator);
        }
        return setMasterPort;
    }

    public static String getIORegistryStringProperty(int entry, String key) {
        String value = null;
        CoreFoundation.CFStringRef keyAsCFString = CfUtil.getCFString(key);
        CoreFoundation.CFTypeRef valueAsCFString = IOKit.INSTANCE.IORegistryEntryCreateCFProperty(entry, keyAsCFString, CoreFoundation.INSTANCE.CFAllocatorGetDefault(), 0);
        if (valueAsCFString != null && valueAsCFString.getPointer() != null) {
            value = CfUtil.cfPointerToString(valueAsCFString.getPointer());
        }
        CfUtil.release(valueAsCFString);
        return value;
    }

    public static long getIORegistryLongProperty(int entry, String key) {
        long value = 0L;
        CoreFoundation.CFStringRef keyAsCFString = CfUtil.getCFString(key);
        CoreFoundation.CFTypeRef valueAsCFNumber = IOKit.INSTANCE.IORegistryEntryCreateCFProperty(entry, keyAsCFString, CoreFoundation.INSTANCE.CFAllocatorGetDefault(), 0);
        if (valueAsCFNumber != null && valueAsCFNumber.getPointer() != null) {
            value = CfUtil.cfPointerToLong(valueAsCFNumber.getPointer());
        }
        CfUtil.release(valueAsCFNumber);
        return value;
    }

    public static byte[] getIORegistryByteArrayProperty(int entry, String key) {
        byte[] value = null;
        CoreFoundation.CFStringRef keyAsCFString = CfUtil.getCFString(key);
        CoreFoundation.CFTypeRef valueAsCFData = IOKit.INSTANCE.IORegistryEntryCreateCFProperty(entry, keyAsCFString, CoreFoundation.INSTANCE.CFAllocatorGetDefault(), 0);
        if (valueAsCFData != null && valueAsCFData.getPointer() != null) {
            int length = CoreFoundation.INSTANCE.CFDataGetLength(valueAsCFData);
            PointerByReference p = CoreFoundation.INSTANCE.CFDataGetBytePtr(valueAsCFData);
            value = p.getPointer().getByteArray(0L, length);
        }
        CfUtil.release(valueAsCFData);
        return value;
    }

    public static CoreFoundation.CFMutableDictionaryRef getBSDNameMatchingDict(String bsdName) {
        if (IOKitUtil.setMasterPort() == 0) {
            return IOKit.INSTANCE.IOBSDNameMatching(masterPort.getValue(), 0, bsdName);
        }
        return null;
    }
}

