/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.api.utils;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hawkular.apm.api.model.Property;
import org.hawkular.apm.api.model.events.EndpointRef;
import org.hawkular.apm.api.model.events.SourceInfo;
import org.hawkular.apm.api.model.trace.ContainerNode;
import org.hawkular.apm.api.model.trace.CorrelationIdentifier;
import org.hawkular.apm.api.model.trace.Node;
import org.hawkular.apm.api.model.trace.Producer;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.api.utils.EndpointUtil;
import org.hawkular.apm.server.api.model.zipkin.Span;
import org.hawkular.apm.server.api.services.SpanCache;
import org.hawkular.apm.server.api.task.RetryAttemptException;
import org.hawkular.apm.server.api.utils.zipkin.SpanDeriverUtil;
import org.hawkular.apm.server.api.utils.zipkin.SpanUniqueIdGenerator;

public class SourceInfoUtil {
    private static final Logger log = Logger.getLogger(SourceInfoUtil.class.getName());

    private SourceInfoUtil() {
    }

    public static List<SourceInfo> getSourceInfo(String tenantId, List<Trace> items) throws RetryAttemptException {
        ArrayList<SourceInfo> sourceInfoList = new ArrayList<SourceInfo>();
        int curpos = 0;
        for (int i = 0; i < items.size(); ++i) {
            Trace trace = items.get(i);
            StringBuffer nodeId = new StringBuffer(trace.getFragmentId());
            for (int j = 0; j < trace.getNodes().size(); ++j) {
                Node node = (Node)trace.getNodes().get(j);
                int len = nodeId.length();
                SourceInfoUtil.initialiseSourceInfo(sourceInfoList, tenantId, trace, nodeId, j, node);
                nodeId.delete(len, nodeId.length());
            }
            EndpointRef ep = EndpointUtil.getSourceEndpoint((Trace)trace);
            for (int j = curpos; j < sourceInfoList.size(); ++j) {
                SourceInfo si = (SourceInfo)sourceInfoList.get(j);
                si.setEndpoint(ep);
            }
            curpos = sourceInfoList.size();
        }
        return sourceInfoList;
    }

    protected static void initialiseSourceInfo(List<SourceInfo> sourceInfoList, String tenantId, Trace trace, StringBuffer parentNodeId, int pos, Node node) {
        List cids;
        SourceInfo si = new SourceInfo();
        parentNodeId.append(':');
        parentNodeId.append(pos);
        si.setId(parentNodeId.toString());
        si.setTimestamp(node.getTimestamp());
        si.setDuration(node.getDuration());
        si.setTraceId(trace.getTraceId());
        si.setFragmentId(trace.getFragmentId());
        si.setHostName(trace.getHostName());
        si.setHostAddress(trace.getHostAddress());
        si.setMultipleConsumers(true);
        si.setProperties(node.getProperties());
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Adding source information for node id=" + si.getId() + " si=" + si);
        }
        sourceInfoList.add(si);
        if (node.getClass() == Producer.class && !(cids = node.findCorrelationIds(new CorrelationIdentifier.Scope[]{CorrelationIdentifier.Scope.Interaction, CorrelationIdentifier.Scope.ControlFlow})).isEmpty()) {
            for (int i = 0; i < cids.size(); ++i) {
                CorrelationIdentifier cid = (CorrelationIdentifier)cids.get(i);
                SourceInfo copy = new SourceInfo(si);
                copy.setId(cid.getValue());
                copy.setMultipleConsumers(((Producer)node).multipleConsumers());
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Extra source information for scope=" + cid.getScope() + " id=" + copy.getId() + " si=" + copy);
                }
                sourceInfoList.add(copy);
            }
        }
        if (node instanceof ContainerNode) {
            int nodeIdLen = parentNodeId.length();
            for (int j = 0; j < ((ContainerNode)node).getNodes().size(); ++j) {
                SourceInfoUtil.initialiseSourceInfo(sourceInfoList, tenantId, trace, parentNodeId, j, (Node)((ContainerNode)node).getNodes().get(j));
                parentNodeId.delete(nodeIdLen, parentNodeId.length());
            }
        }
    }

    protected static Span findRootOrServerSpan(String tenantId, Span span, SpanCache spanCache) {
        while (span != null && !span.serverSpan() && !span.topLevelSpan()) {
            span = (Span)spanCache.get(tenantId, span.getParentId());
        }
        return span;
    }

    public static SourceInfo getSourceInfo(String tenantId, Span serverSpan, SpanCache spanCache) {
        Span clientSpan;
        Span rootOrServerSpan;
        String clientSpanId = SpanUniqueIdGenerator.getClientId(serverSpan.getId());
        if (spanCache != null && clientSpanId != null && (rootOrServerSpan = SourceInfoUtil.findRootOrServerSpan(tenantId, clientSpan = (Span)spanCache.get(tenantId, clientSpanId), spanCache)) != null) {
            SourceInfo si = new SourceInfo();
            if (clientSpan.getDuration() != null) {
                si.setDuration(clientSpan.getDuration().longValue());
            }
            if (clientSpan.getTimestamp() != null) {
                si.setTimestamp(clientSpan.getTimestamp().longValue());
            }
            si.setTraceId(clientSpan.getTraceId());
            si.setFragmentId(clientSpan.getId());
            si.getProperties().addAll(clientSpan.binaryAnnotationMapping().getProperties());
            si.setHostAddress(clientSpan.ipv4());
            if (clientSpan.service() != null) {
                si.getProperties().add(new Property("service", (Object)clientSpan.service()));
            }
            si.setId(clientSpan.getId());
            si.setMultipleConsumers(false);
            URL url = rootOrServerSpan.url();
            si.setEndpoint(new EndpointRef(url != null ? url.getPath() : null, SpanDeriverUtil.deriveOperation(rootOrServerSpan), !rootOrServerSpan.serverSpan()));
            return si;
        }
        return null;
    }
}

