/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.api.utils.zipkin;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import org.hawkular.apm.server.api.utils.zipkin.BinaryAnnotationMapping;
import org.jboss.logging.Logger;

public class BinaryAnnotationMappingStorage {
    private static Logger log = Logger.getLogger((String)BinaryAnnotationMappingStorage.class.getName());
    private static final String HAWKULAR_ZIPKIN_BINARY_ANNOTATION_MAPPING = "zipkin-binary-annotation-mapping.json";
    private Map<String, BinaryAnnotationMapping> keyBasedMappings;

    public BinaryAnnotationMappingStorage() {
        String jbossConfigDir = System.getProperties().getProperty("jboss.server.config.dir");
        if (jbossConfigDir == null) {
            log.errorf("Property jboss.server.config.dir is not set, Binary Annotation mapping rules set to empty", new Object[0]);
            this.keyBasedMappings = Collections.emptyMap();
            return;
        }
        String path = System.getProperty("jboss.server.config.dir") + File.separatorChar + HAWKULAR_ZIPKIN_BINARY_ANNOTATION_MAPPING;
        this.loadMappings(path);
    }

    public BinaryAnnotationMappingStorage(String file) {
        this.loadMappings(file);
    }

    private void loadMappings(String path) {
        try {
            String file = this.readFile(new File(path));
            TypeReference<Map<String, BinaryAnnotationMapping>> typeReference = new TypeReference<Map<String, BinaryAnnotationMapping>>(){};
            ObjectMapper objectMapper = new ObjectMapper();
            JsonParser parser = objectMapper.getFactory().createParser(file);
            this.keyBasedMappings = Collections.unmodifiableMap((Map)parser.readValueAs((TypeReference)typeReference));
        }
        catch (IOException ex) {
            log.errorf("Could not load Zipkin binary annotation mapping file %s", (Object)path);
            this.keyBasedMappings = Collections.emptyMap();
        }
    }

    public Map<String, BinaryAnnotationMapping> getKeyBasedMappings() {
        return this.keyBasedMappings;
    }

    private String readFile(File file) throws IOException {
        byte[] bytes = Files.readAllBytes(Paths.get(file.toURI()));
        return new String(bytes);
    }
}

