/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.api.utils.zipkin;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import org.hawkular.apm.server.api.model.zipkin.Annotation;
import org.hawkular.apm.server.api.model.zipkin.AnnotationType;
import org.hawkular.apm.server.api.model.zipkin.Endpoint;
import org.hawkular.apm.server.api.model.zipkin.Span;
import zipkin.BinaryAnnotation;
import zipkin.internal.ApplyTimestampAndDuration;

public class ZipkinSpanConvertor {
    private ZipkinSpanConvertor() {
    }

    public static Span span(zipkin.Span zipkinSpan) {
        zipkinSpan = ApplyTimestampAndDuration.apply((zipkin.Span)zipkinSpan);
        Span span = new Span(ZipkinSpanConvertor.binaryAnnotations(zipkinSpan.binaryAnnotations), ZipkinSpanConvertor.annotations(zipkinSpan.annotations));
        span.setId(ZipkinSpanConvertor.parseSpanId(zipkinSpan.id));
        span.setTraceId(ZipkinSpanConvertor.parseSpanId(zipkinSpan.traceId));
        span.setParentId(zipkinSpan.parentId == null ? null : ZipkinSpanConvertor.parseSpanId(zipkinSpan.parentId));
        span.setName(zipkinSpan.name);
        span.setDebug(zipkinSpan.debug);
        span.setTimestamp(zipkinSpan.timestamp);
        span.setDuration(zipkinSpan.duration == null ? 0L : zipkinSpan.duration);
        return span;
    }

    public static Endpoint endpoint(zipkin.Endpoint zipkinEndpoint) {
        if (zipkinEndpoint == null) {
            return null;
        }
        Endpoint endpoint = new Endpoint();
        endpoint.setServiceName(zipkinEndpoint.serviceName);
        endpoint.setIpv4(ZipkinSpanConvertor.parseIpv4(zipkinEndpoint.ipv4));
        endpoint.setPort(zipkinEndpoint.port);
        return endpoint;
    }

    public static Annotation annotation(zipkin.Annotation zipkinAnnotation) {
        Annotation annotation = new Annotation();
        annotation.setValue(zipkinAnnotation.value);
        annotation.setTimestamp(zipkinAnnotation.timestamp);
        annotation.setEndpoint(ZipkinSpanConvertor.endpoint(zipkinAnnotation.endpoint));
        return annotation;
    }

    public static org.hawkular.apm.server.api.model.zipkin.BinaryAnnotation binaryAnnotation(BinaryAnnotation zipkinBinaryAnnotation) {
        org.hawkular.apm.server.api.model.zipkin.BinaryAnnotation binaryAnnotation = new org.hawkular.apm.server.api.model.zipkin.BinaryAnnotation();
        binaryAnnotation.setKey(zipkinBinaryAnnotation.key);
        binaryAnnotation.setValue(ZipkinSpanConvertor.parseBinaryAnnotationValue(zipkinBinaryAnnotation));
        binaryAnnotation.setType(ZipkinSpanConvertor.annotationType(zipkinBinaryAnnotation.type));
        binaryAnnotation.setEndpoint(ZipkinSpanConvertor.endpoint(zipkinBinaryAnnotation.endpoint));
        return binaryAnnotation;
    }

    public static AnnotationType annotationType(BinaryAnnotation.Type zipkinType) {
        AnnotationType annotationType;
        switch (zipkinType) {
            case BOOL: {
                annotationType = AnnotationType.BOOL;
                break;
            }
            case STRING: {
                annotationType = AnnotationType.STRING;
                break;
            }
            case DOUBLE: {
                annotationType = AnnotationType.DOUBLE;
                break;
            }
            case BYTES: {
                annotationType = AnnotationType.BYTES;
                break;
            }
            case I16: {
                annotationType = AnnotationType.I16;
                break;
            }
            case I32: {
                annotationType = AnnotationType.I32;
                break;
            }
            case I64: {
                annotationType = AnnotationType.I64;
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong zipkin annotation type");
            }
        }
        return annotationType;
    }

    public static List<Annotation> annotations(List<zipkin.Annotation> zipkinAnnotations) {
        if (zipkinAnnotations == null) {
            return null;
        }
        return zipkinAnnotations.stream().map(ZipkinSpanConvertor::annotation).collect(Collectors.toList());
    }

    public static List<org.hawkular.apm.server.api.model.zipkin.BinaryAnnotation> binaryAnnotations(List<BinaryAnnotation> zipkinBinAnnotations) {
        if (zipkinBinAnnotations == null) {
            return null;
        }
        return zipkinBinAnnotations.stream().map(ZipkinSpanConvertor::binaryAnnotation).collect(Collectors.toList());
    }

    public static List<Span> spans(List<zipkin.Span> zipkinSpans) {
        return zipkinSpans.stream().map(ZipkinSpanConvertor::span).collect(Collectors.toList());
    }

    private static String parseBinaryAnnotationValue(BinaryAnnotation zipkinBinAnnotation) {
        if (zipkinBinAnnotation == null || zipkinBinAnnotation.value == null) {
            return null;
        }
        String value = null;
        switch (zipkinBinAnnotation.type) {
            case BOOL: {
                value = zipkinBinAnnotation.value[0] == 1 ? "true" : "false";
                break;
            }
            case STRING: {
                value = new String(zipkinBinAnnotation.value);
                break;
            }
            case BYTES: {
                value = String.valueOf(zipkinBinAnnotation.value);
                break;
            }
            case I16: {
                value = String.valueOf(ByteBuffer.wrap(zipkinBinAnnotation.value).getShort());
                break;
            }
            case I32: {
                value = String.valueOf(ByteBuffer.wrap(zipkinBinAnnotation.value).getInt());
                break;
            }
            case I64: {
                value = String.valueOf(ByteBuffer.wrap(zipkinBinAnnotation.value).getLong());
                break;
            }
            case DOUBLE: {
                String.valueOf(Double.longBitsToDouble(ByteBuffer.wrap(zipkinBinAnnotation.value).getLong()));
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    private static String parseIpv4(int ipv4) {
        if (ipv4 == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ipv4 >> 24 & 0xFF).append(".");
        stringBuilder.append(ipv4 >> 16 & 0xFF).append(".");
        stringBuilder.append(ipv4 >> 8 & 0xFF).append(".");
        stringBuilder.append(ipv4 & 0xFF);
        return stringBuilder.toString();
    }

    public static String parseSpanId(long id) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ZipkinSpanConvertor.hex((byte)(id >>> 56 & 0xFFL)));
        stringBuilder.append(ZipkinSpanConvertor.hex((byte)(id >>> 48 & 0xFFL)));
        stringBuilder.append(ZipkinSpanConvertor.hex((byte)(id >>> 40 & 0xFFL)));
        stringBuilder.append(ZipkinSpanConvertor.hex((byte)(id >>> 32 & 0xFFL)));
        stringBuilder.append(ZipkinSpanConvertor.hex((byte)(id >>> 24 & 0xFFL)));
        stringBuilder.append(ZipkinSpanConvertor.hex((byte)(id >>> 16 & 0xFFL)));
        stringBuilder.append(ZipkinSpanConvertor.hex((byte)(id >>> 8 & 0xFFL)));
        stringBuilder.append(ZipkinSpanConvertor.hex((byte)(id & 0xFFL)));
        return stringBuilder.toString();
    }

    private static String hex(byte b) {
        return String.format("%02X", b);
    }
}

