/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.EntityAlreadyExistsException;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResolvableToSingle;
import org.hawkular.inventory.api.ResolvableToSingleWithRelationships;
import org.hawkular.inventory.api.TransactionFrame;
import org.hawkular.inventory.api.WriteInterface;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.ElementBlueprintVisitor;
import org.hawkular.inventory.api.model.ElementTypeVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.rest.RestApiLogger;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.RestBulk;

/*
 * Exception performing whole class analysis ignored.
 */
@javax.ws.rs.Path(value="/bulk")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/bulk", description="Endpoint for bulk operations on inventory entities")
public class RestBulk
extends RestBase {
    private static CanonicalPath canonicalize(String path, CanonicalPath rootPath) {
        Object p = path == null || path.isEmpty() ? rootPath : Path.fromPartiallyUntypedString((String)path, (CanonicalPath)rootPath, (CanonicalPath)rootPath, Entity.class);
        if (p.isRelative()) {
            p = p.toRelativePath().applyTo(rootPath);
        }
        return p.toCanonicalPath();
    }

    private static void putStatus(Map<ElementType, Map<CanonicalPath, Integer>> statuses, ElementType et, CanonicalPath cp, Integer status) {
        Map<CanonicalPath, Integer> typeStatuses = statuses.get(et);
        if (typeStatuses == null) {
            typeStatuses = new HashMap<CanonicalPath, Integer>();
            statuses.put(et, typeStatuses);
        }
        typeStatuses.put(cp, status);
    }

    private static String arrow(Relationship.Blueprint b) {
        switch (3.$SwitchMap$org$hawkular$inventory$api$Relationships$Direction[b.getDirection().ordinal()]) {
            case 1: {
                return "<-(" + b.getName() + ")->";
            }
            case 2: {
                return "-(" + b.getName() + ")->";
            }
            case 3: {
                return "<-(" + b.getName() + ")-";
            }
        }
        throw new IllegalStateException("Unhandled direction type: " + b.getDirection());
    }

    private static WriteInterface<?, ?, ?, ?> step(Class<?> elementClass, Class<?> nextType, ResolvableToSingle<?, ?> single) {
        return (WriteInterface)ElementTypeVisitor.accept(elementClass, (ElementTypeVisitor)new /* Unavailable Anonymous Inner Class!! */, null);
    }

    private static ResolvableToSingle<?, ?> create(Blueprint b, WriteInterface<?, ?, ?, ?> wrt) {
        return (ResolvableToSingle)b.accept((ElementBlueprintVisitor)new /* Unavailable Anonymous Inner Class!! */, null);
    }

    @POST
    @javax.ws.rs.Path(value="/")
    @ApiOperation(value="Bulk creation of new entities. The response body contains details about results of creation of individual entities. The return value is a map where keys are types of entities created and values are again maps where keys are the canonical paths of the entities to be created and values are HTTP status codes - 201 OK, 400 if invalid path is supplied, 409 if the entity already exists on given path or 500 in case of internal error.")
    @ApiResponses(value={@ApiResponse(code=201, message="Entities successfully created")})
    public Response addEntities(@ApiParam(value="This is a map where keys are paths to the parents under which entities should be created. The values are again maps where keys are one of [environment, resourceType, metricType, operationType, feed, resource, metric, dataEntity, relationship] and values are arrays of blueprints of entities of the corresponding types.") Map<String, Map<ElementType, List<Object>>> entities, @Context UriInfo uriInfo) {
        CanonicalPath rootPath = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(this.getTenantId())).get();
        Map statuses = this.bulkCreate(entities, rootPath);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)statuses).build();
    }

    private Map<ElementType, Map<CanonicalPath, Integer>> bulkCreate(Map<String, Map<ElementType, List<Object>>> entities, CanonicalPath rootPath) {
        HashMap<ElementType, Map<CanonicalPath, Integer>> statuses = new HashMap<ElementType, Map<CanonicalPath, Integer>>();
        TransactionFrame transaction = this.inventory.newTransactionFrame();
        Inventory binv = transaction.boundInventory();
        IdExtractor idExtractor = new IdExtractor(null);
        try {
            for (Map.Entry<String, Map<ElementType, List<Object>>> e : entities.entrySet()) {
                Map<ElementType, List<Object>> allBlueprints = e.getValue();
                CanonicalPath parentPath = RestBulk.canonicalize((String)e.getKey(), (CanonicalPath)rootPath);
                ResolvableToSingle single = binv.inspect(parentPath, ResolvableToSingle.class);
                for (Map.Entry<ElementType, List<Object>> ee : allBlueprints.entrySet()) {
                    ElementType elementType = ee.getKey();
                    List<Object> rawBlueprints = ee.getValue();
                    List blueprints = this.deserializeBlueprints(elementType, rawBlueprints);
                    if (elementType == ElementType.relationship) {
                        this.bulkCreateRelationships(statuses, parentPath, (ResolvableToSingleWithRelationships)single, elementType, blueprints);
                        continue;
                    }
                    this.bulkCreateEntity(statuses, idExtractor, parentPath, single, elementType, blueprints);
                }
            }
            transaction.commit();
            return statuses;
        }
        catch (Throwable t) {
            transaction.rollback();
            throw t;
        }
    }

    private List<Blueprint> deserializeBlueprints(ElementType elementType, List<Object> rawBlueprints) {
        return rawBlueprints.stream().map(o -> {
            try {
                String js = this.mapper.writeValueAsString(o);
                return (Blueprint)this.mapper.reader(elementType.blueprintType).readValue(js);
            }
            catch (IOException e1) {
                throw new IllegalArgumentException("Failed to deserialize as " + elementType.blueprintType + " the following data: " + o, e1);
            }
        }).collect(Collectors.toList());
    }

    private void bulkCreateEntity(Map<ElementType, Map<CanonicalPath, Integer>> statuses, IdExtractor idExtractor, CanonicalPath parentPath, ResolvableToSingle<?, ?> single, ElementType elementType, List<Blueprint> blueprints) {
        if (!parentPath.modified().canExtendTo(elementType.elementType).booleanValue()) {
            RestBulk.putStatus(statuses, (ElementType)elementType, (CanonicalPath)parentPath, (Integer)Response.Status.BAD_REQUEST.getStatusCode());
            return;
        }
        if (!this.canCreateUnderParent(elementType, parentPath)) {
            for (Blueprint b : blueprints) {
                String id = (String)b.accept((ElementBlueprintVisitor)idExtractor, null);
                RestBulk.putStatus(statuses, (ElementType)elementType, (CanonicalPath)parentPath.extend(elementType.elementType, id).get(), (Integer)Response.Status.FORBIDDEN.getStatusCode());
            }
            return;
        }
        for (Blueprint b : blueprints) {
            String id = (String)b.accept((ElementBlueprintVisitor)idExtractor, null);
            CanonicalPath childPath = parentPath.extend(elementType.elementType, id).get();
            WriteInterface wrt = RestBulk.step((Class)parentPath.getSegment().getElementType(), (Class)elementType.elementType, single);
            try {
                RestBulk.create((Blueprint)b, (WriteInterface)wrt);
                RestBulk.putStatus(statuses, (ElementType)elementType, (CanonicalPath)childPath, (Integer)Response.Status.CREATED.getStatusCode());
            }
            catch (EntityAlreadyExistsException ex) {
                RestBulk.putStatus(statuses, (ElementType)elementType, (CanonicalPath)childPath, (Integer)Response.Status.CONFLICT.getStatusCode());
            }
            catch (Exception ex) {
                RestApiLogger.LOGGER.failedToCreateBulkEntity(childPath, (Throwable)ex);
                RestBulk.putStatus(statuses, (ElementType)elementType, (CanonicalPath)childPath, (Integer)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            }
        }
    }

    private void bulkCreateRelationships(Map<ElementType, Map<CanonicalPath, Integer>> statuses, CanonicalPath parentPath, ResolvableToSingleWithRelationships<?, ?> single, ElementType elementType, List<Blueprint> blueprints) {
        if (!this.security.canAssociateFrom(parentPath)) {
            for (Blueprint b : blueprints) {
                Relationship.Blueprint rb = (Relationship.Blueprint)b;
                String id = parentPath.toString() + RestBulk.arrow((Relationship.Blueprint)rb) + rb.getOtherEnd();
                RestBulk.putStatus(statuses, (ElementType)elementType, (CanonicalPath)parentPath.extend(elementType.elementType, id).get(), (Integer)Response.Status.FORBIDDEN.getStatusCode());
            }
            return;
        }
        for (Blueprint b : blueprints) {
            Relationship.Blueprint rb = (Relationship.Blueprint)b;
            try {
                Relationships.Single rel = (Relationships.Single)((Relationships.ReadWrite)single.relationships(rb.getDirection())).linkWith(rb.getName(), rb.getOtherEnd(), rb.getProperties());
                RestBulk.putStatus(statuses, (ElementType)elementType, (CanonicalPath)((Relationship)rel.entity()).getPath(), (Integer)Response.Status.CREATED.getStatusCode());
            }
            catch (EntityNotFoundException ex) {
                String fakeId = parentPath.toString() + RestBulk.arrow((Relationship.Blueprint)rb) + rb.getOtherEnd().toString();
                RestBulk.putStatus(statuses, (ElementType)elementType, (CanonicalPath)((CanonicalPath)((CanonicalPath.RelationshipBuilder)CanonicalPath.of().relationship(fakeId)).get()), (Integer)Response.Status.NOT_FOUND.getStatusCode());
            }
        }
    }

    private boolean canCreateUnderParent(ElementType elementType, CanonicalPath parentPath) {
        switch (3.$SwitchMap$org$hawkular$inventory$rest$RestBulk$ElementType[elementType.ordinal()]) {
            case 1: {
                return this.security.canUpdate(parentPath);
            }
            case 2: {
                throw new IllegalArgumentException("Cannot create anything under a relationship.");
            }
        }
        return this.security.canCreate(elementType.elementType).under(parentPath);
    }

    static /* synthetic */ String access$100(Relationship.Blueprint x0) {
        return RestBulk.arrow((Relationship.Blueprint)x0);
    }
}

