/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.rest.RequestUtil;
import org.hawkular.inventory.rest.RestResources;
import org.hawkular.inventory.rest.json.ApiError;
import org.hawkular.inventory.rest.security.EntityIdUtils;

@javax.ws.rs.Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/", description="Resource Metrics CRUD")
public class RestResourcesMetrics
extends RestResources {
    @POST
    @javax.ws.rs.Path(value="/{environmentId}/resources/{resourcePath:.+}/metrics")
    @ApiOperation(value="Associates a pre-existing metric with a resource")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, resource or metric doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response associateMetrics(@PathParam(value="environmentId") String environmentId, @Encoded @PathParam(value="resourcePath") String resourcePath, @ApiParam(value="A list of paths to metrics to be associated with the resource. They can either be canonical or relative to the resource.") Collection<String> metricPaths) {
        String tenantId = this.getTenantId();
        CanonicalPath tenant = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get();
        CanonicalPath resource = this.composeCanonicalPath(tenantId, environmentId, null, resourcePath);
        if (!this.security.canAssociateFrom(resource)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Metrics.ReadAssociate metricDao = (Metrics.ReadAssociate)((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).metrics();
        metricPaths.stream().map(p -> Path.fromPartiallyUntypedString((String)p, (CanonicalPath)tenant, (CanonicalPath)resource, Metric.class)).forEach(x$0 -> metricDao.associate(x$0));
        return Response.noContent().build();
    }

    @POST
    @javax.ws.rs.Path(value="/{environmentId}/{feedId}/resources/{resourcePath:.+}/metrics")
    @ApiOperation(value="Associates a pre-existing metric with a resource")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, resource or metric doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response associateMetrics(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @Encoded @PathParam(value="resourcePath") String resourcePath, Collection<String> metricPaths) {
        String tenantId = this.getTenantId();
        CanonicalPath tenant = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get();
        CanonicalPath resource = this.composeCanonicalPath(tenantId, environmentId, feedId, resourcePath);
        if (!this.security.canAssociateFrom(resource)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Metrics.ReadAssociate metricDao = (Metrics.ReadAssociate)((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).metrics();
        metricPaths.stream().map(p -> Path.fromPartiallyUntypedString((String)p, (CanonicalPath)tenant, (CanonicalPath)resource, Metric.class)).forEach(x$0 -> metricDao.associate(x$0));
        return Response.noContent().build();
    }

    @GET
    @javax.ws.rs.Path(value="/{environmentId}/resources/{resourcePath:.+}/metrics")
    @ApiOperation(value="Retrieves all metrics associated with a resource. Accepts paging query parameters.")
    @ApiResponses(value={@ApiResponse(code=200, message="The list of metrics"), @ApiResponse(code=404, message="Tenant, environment or resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAssociatedMetrics(@PathParam(value="environmentId") String environmentID, @Encoded @PathParam(value="resourcePath") String resourcePath, @Context UriInfo uriInfo) {
        CanonicalPath resource = this.composeCanonicalPath(this.getTenantId(), environmentID, null, resourcePath);
        Page ms = ((Metrics.Multiple)((Metrics.ReadAssociate)((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).metrics()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return this.pagedResponse(Response.ok(), uriInfo, ms).build();
    }

    @GET
    @javax.ws.rs.Path(value="/{environmentId}/{feedId}/resources/{resourcePath:.+}/metrics")
    @ApiOperation(value="Retrieves all metrics associated with a resource. Accepts paging query parameters.")
    @ApiResponses(value={@ApiResponse(code=200, message="The list of metrics"), @ApiResponse(code=404, message="Tenant, environment, feed or resource doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAssociatedMetrics(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @Encoded @PathParam(value="resourcePath") String resourcePath, @Context UriInfo uriInfo) {
        CanonicalPath resource = this.composeCanonicalPath(this.getTenantId(), environmentId, feedId, resourcePath);
        Page ms = ((Metrics.Multiple)((Metrics.ReadAssociate)((Resources.Single)this.inventory.inspect(resource, Resources.Single.class)).metrics()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return this.pagedResponse(Response.ok(), uriInfo, ms).build();
    }

    @GET
    @javax.ws.rs.Path(value="/{environmentId}/resources/{resourcePath:.+}/metrics/{metricPath:.+}")
    @ApiOperation(value="Retrieves a single metric associated with a resource")
    @ApiResponses(value={@ApiResponse(code=200, message="The resource"), @ApiResponse(code=404, message="Tenant, environment, resource or metric does not exist or the metric is not associated with the resource", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAssociatedMetric(@PathParam(value="environmentId") String environmentId, @Encoded @PathParam(value="resourcePath") String resourcePath, @Encoded @PathParam(value="metricPath") String metricPath, @QueryParam(value="canonical") @DefaultValue(value="false") @ApiParam(value="True if metric path should be considered canonical, false by default.") boolean isCanonical) {
        Path mp;
        String tenantId = this.getTenantId();
        CanonicalPath tenant = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get();
        CanonicalPath rp = this.composeCanonicalPath(tenantId, environmentId, null, resourcePath);
        if (isCanonical) {
            metricPath = "/" + metricPath;
        }
        if (EntityIdUtils.isTenantEscapeAttempt((CanonicalPath)rp, (Path)(mp = Path.fromPartiallyUntypedString((String)metricPath, (CanonicalPath)tenant, (CanonicalPath)rp, Metric.class)))) {
            Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Metric m = (Metric)((Metrics.Single)((Metrics.ReadAssociate)((Resources.Single)this.inventory.inspect(rp, Resources.Single.class)).metrics()).get((Object)mp)).entity();
        return Response.ok((Object)m).build();
    }

    @GET
    @javax.ws.rs.Path(value="/{environmentId}/{feedId}/resources/{resourcePath:.+}/metrics/{metricPath:.+}")
    @ApiOperation(value="Retrieves a single resource")
    @ApiResponses(value={@ApiResponse(code=200, message="The resource"), @ApiResponse(code=404, message="Tenant, environment, feed, resource or metric doesn't exist or if the metric is not associated with the resource", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAssociatedMetric(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @Encoded @PathParam(value="resourcePath") String resourcePath, @Encoded @PathParam(value="metricPath") String metricPath, @QueryParam(value="canonical") @DefaultValue(value="false") @ApiParam(value="True if metric path should be considered canonical, false by default.") boolean isCanonical) {
        Path mp;
        String tenantId = this.getTenantId();
        CanonicalPath tenant = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get();
        CanonicalPath rp = this.composeCanonicalPath(tenantId, environmentId, feedId, resourcePath);
        if (isCanonical) {
            metricPath = "/" + metricPath;
        }
        if (EntityIdUtils.isTenantEscapeAttempt((CanonicalPath)rp, (Path)(mp = Path.fromPartiallyUntypedString((String)metricPath, (CanonicalPath)tenant, (CanonicalPath)rp, Metric.class)))) {
            Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Metric m = (Metric)((Metrics.Single)((Metrics.ReadAssociate)((Resources.Single)this.inventory.inspect(rp, Resources.Single.class)).metrics()).get((Object)mp)).entity();
        return Response.ok((Object)m).build();
    }

    @DELETE
    @javax.ws.rs.Path(value="/{environmentId}/resources/{resourcePath:.+}/metrics/{metricPath:.+}")
    @ApiOperation(value="Disassociates the given resource from the given metric")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, resource or metric does not exist or the metric is not associated with the resource", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response disassociateMetric(@PathParam(value="environmentId") String environmentId, @Encoded @PathParam(value="resourcePath") String resourcePath, @Encoded @PathParam(value="metricPath") String metricPath, @QueryParam(value="canonical") @DefaultValue(value="false") @ApiParam(value="True if metric path should be considered canonical, false by default.") boolean isCanonical) {
        Path mp;
        String tenantId = this.getTenantId();
        CanonicalPath tenant = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get();
        CanonicalPath rp = this.composeCanonicalPath(tenantId, environmentId, null, resourcePath);
        if (!this.security.canAssociateFrom(rp)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (isCanonical) {
            metricPath = "/" + metricPath;
        }
        if (EntityIdUtils.isTenantEscapeAttempt((CanonicalPath)rp, (Path)(mp = Path.fromPartiallyUntypedString((String)metricPath, (CanonicalPath)tenant, (CanonicalPath)rp, Metric.class)))) {
            Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Metrics.ReadAssociate)((Resources.Single)this.inventory.inspect(rp, Resources.Single.class)).metrics()).disassociate(mp);
        return Response.noContent().build();
    }

    @DELETE
    @javax.ws.rs.Path(value="/{environmentId}/{feedId}/resources/{resourcePath:.+}/metrics/{metricPath:.+}")
    @ApiOperation(value="Disassociates the given resource from the given metric")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=404, message="Tenant, environment, feed, resource or metric does not exist or the metric is not associated with the resource", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response disassociateMetric(@PathParam(value="environmentId") String environmentId, @PathParam(value="feedId") String feedId, @Encoded @PathParam(value="resourcePath") String resourcePath, @Encoded @PathParam(value="metricPath") String metricPath, @QueryParam(value="canonical") @DefaultValue(value="false") @ApiParam(value="True if metric path should be considered canonical, false by default.") boolean isCanonical) {
        Path mp;
        String tenantId = this.getTenantId();
        CanonicalPath tenant = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get();
        CanonicalPath rp = this.composeCanonicalPath(tenantId, environmentId, feedId, resourcePath);
        if (!this.security.canAssociateFrom(rp)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (isCanonical) {
            metricPath = "/" + metricPath;
        }
        if (EntityIdUtils.isTenantEscapeAttempt((CanonicalPath)rp, (Path)(mp = Path.fromPartiallyUntypedString((String)metricPath, (CanonicalPath)tenant, (CanonicalPath)rp, Metric.class)))) {
            Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((Metrics.ReadAssociate)((Resources.Single)this.inventory.inspect(rp, Resources.Single.class)).metrics()).disassociate(mp);
        return Response.noContent().build();
    }
}

