/*
 * Decompiled with CFR 0.152.
 */
package org.hellojavaer.ddal.spring.scan;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.hellojavaer.ddal.ddr.shard.ShardRouteContext;
import org.hellojavaer.ddal.ddr.shard.annotation.ShardRoute;
import org.hellojavaer.ddal.ddr.shard.enums.ContextPropagation;
import org.hellojavaer.ddal.ddr.utils.DDRStringUtils;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class EnableShardRouteAnnotation {
    private ParameterNameDiscoverer parameterNameDiscoverer = null;
    private static boolean notSupportParameterNameDiscoverer = false;
    private Map<Method, InnerBean> expressionCache = new HashMap<Method, InnerBean>();
    private static ParserContext PARSER_CONTEXT = new ParserContext(){

        public boolean isTemplate() {
            return false;
        }

        public String getExpressionPrefix() {
            return null;
        }

        public String getExpressionSuffix() {
            return null;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(shardRoute)")
    public Object around(ProceedingJoinPoint joinPoint, ShardRoute shardRoute) throws Throwable {
        try {
            if (shardRoute.value() == ContextPropagation.SUB_CONTEXT) {
                ShardRouteContext.pushSubContext();
            } else {
                ShardRouteContext.clear();
            }
            if (shardRoute.scName() != null && shardRoute.scName().length() > 0 && shardRoute.sdValue() != null && shardRoute.sdValue().length() > 0) {
                MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
                Method method = methodSignature.getMethod();
                InnerBean innerBean = this.expressionCache.get(method);
                Object[] args = joinPoint.getArgs();
                Object val = null;
                if (innerBean == null) {
                    EnableShardRouteAnnotation enableShardRouteAnnotation = this;
                    synchronized (enableShardRouteAnnotation) {
                        innerBean = this.expressionCache.get(method);
                        if (innerBean == null) {
                            SpelExpressionParser parser = new SpelExpressionParser();
                            Expression expression0 = null;
                            String sdValue = shardRoute.sdValue();
                            if ((sdValue = DDRStringUtils.trimToNull((String)sdValue)) != null) {
                                expression0 = parser.parseExpression(sdValue, PARSER_CONTEXT);
                            }
                            String[] paramNames = this.getParameterNames(method);
                            val = this.calculate(expression0, paramNames, args);
                            InnerBean innerBean1 = new InnerBean(paramNames, expression0);
                            innerBean1.getExpression();
                            this.expressionCache.put(method, innerBean1);
                        } else {
                            val = this.calculate(innerBean.getExpression(), innerBean.getParameterNames(), args);
                        }
                    }
                } else {
                    val = this.calculate(innerBean.getExpression(), innerBean.getParameterNames(), args);
                }
                ShardRouteContext.setDefaultRouteInfo((String)shardRoute.scName(), (Object)val);
            } else if (shardRoute.scName() != null && shardRoute.scName().length() != 0 || shardRoute.sdValue() != null && shardRoute.sdValue().length() != 0) {
                throw new IllegalArgumentException("scName and sdValue should either both have a non-empty value or both have a empty value");
            }
            Object object = joinPoint.proceed(joinPoint.getArgs());
            return object;
        }
        finally {
            if (shardRoute.value() == ContextPropagation.SUB_CONTEXT) {
                ShardRouteContext.popSubContext();
            } else {
                ShardRouteContext.clear();
            }
        }
    }

    private String[] getParameterNames(Method method) {
        if (notSupportParameterNameDiscoverer) {
            return null;
        }
        try {
            this.parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
            return this.parameterNameDiscoverer.getParameterNames(method);
        }
        catch (NoClassDefFoundError e) {
            notSupportParameterNameDiscoverer = true;
            return null;
        }
    }

    private Object calculate(Expression expression, String[] parameterNames, Object[] args) {
        Object ret;
        if (expression == null) {
            return null;
        }
        StandardEvaluationContext context = new StandardEvaluationContext();
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (parameterNames != null && parameterNames.length > i) {
                    context.setVariable(parameterNames[i], args[i]);
                }
                context.setVariable("$" + i, args[i]);
            }
        }
        if ((ret = expression.getValue((EvaluationContext)context)) == null) {
            return null;
        }
        if (ret instanceof List) {
            if (((List)ret).isEmpty()) {
                return null;
            }
            return ((List)ret).get(0);
        }
        return ret;
    }

    private class InnerBean {
        private String[] parameterNames;
        private Expression expression;

        public InnerBean(String[] parameterNames, Expression expression) {
            this.parameterNames = parameterNames;
            this.expression = expression;
        }

        public String[] getParameterNames() {
            return this.parameterNames;
        }

        public void setParameterNames(String[] parameterNames) {
            this.parameterNames = parameterNames;
        }

        public Expression getExpression() {
            return this.expression;
        }

        public void setExpression(Expression expression) {
            this.expression = expression;
        }
    }
}

