package org.hepeng.commons.service;

import java.util.Objects;

/**
 *
 * @author he peng
 */
public class CommonServiceCallResult<E extends ServiceError,D extends Object> implements ServiceCallResult {

    private E error;
    private D data;

    private CommonServiceCallResult(E error, D data) {
        this.error = error;
        this.data = data;
    }

    /**
     * 返回一个新的 ServiceCallResult 实例对象
     * @param error
     * @param data
     * @param <E>
     * @param <D>
     * @return
     */
    public static <E extends ServiceError, D extends Object> CommonServiceCallResult newServiceCallResult(E error, D data) {
        return new CommonServiceCallResult(error , data);
    }

    /**
     * 返回一个新的 ServiceCallResult 实例对象
     * @param error
     * @param <E>
     * @return
     */
    public static <E extends ServiceError> CommonServiceCallResult newServiceCallResult(E error) {
        return newServiceCallResult(error , null);
    }

    @Override
    public Boolean isSuccess() {
        if (Objects.equals(this.error.getErrorCode() , ServiceError.SUCCESS.getErrorCode())) {
            return true;
        }
        return false;
    }

    @Override
    public ServiceError getError() {
        return this.error;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public String toString() {
        return "CommonServiceCallResult{" +
                "error=" + error +
                ", data=" + data +
                '}';
    }
}
