package org.hepeng.commons.service;

import java.io.Serializable;

/**
 * 服务调用结果顶级接口
 * @author he peng
 */
public interface ServiceCallResult<E extends ServiceError , D extends Object> extends Serializable {

    /**
     * 检测服务调用是否成功 ， true - 表示服务调用成功； false - 表示服务调用失败；
     * @return
     */
    Boolean isSuccess();

    /**
     * 获取服务调用结果中的错误信息
     * @return
     */
    E getError();

    /**
     * 获取服务调用后的结果数据
     * @return
     */
    D getData();
}
