package org.hepeng.commons.service;

import java.io.Serializable;

/**
 * 服务错误码顶级接口
 * @author he peng
 */
public interface ServiceError extends Serializable {

    ServiceError SUCCESS = ServiceErrorLoader.loadServiceError("success");
    ServiceError UNKNOWN_ERROR = ServiceErrorLoader.loadServiceError("unknown_error");
    ServiceError PARAMETER_ERROR = ServiceErrorLoader.loadServiceError("parameter_error");
    ServiceError SERVICE_ERROR = ServiceErrorLoader.loadServiceError("service_error");

    /**
     * 获取错误码
     * @return
     */
    Integer getErrorCode();

    /**
     * 获取错误信息
     * @return
     */
    String getErrorMsg();
}
