package org.hepeng.commons.service;

import org.apache.commons.lang3.StringUtils;
import org.hepeng.commons.exception.ApplicationRuntimeException;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * @author he peng
 */
public class ServiceErrorLoader {

    private static final String SERVICE_ERROR_FILE_PATH_KEY = "hp.java.commons.service.error";
    private static final String DEFAULT_SERVICE_ERROR_FILE_PATH = "META-INF/default-service-error.properties";
    private static final Properties SERVICE_ERROR_PROPS = new Properties();

    static {
        String serviceErrorFilePath = System.getProperty(SERVICE_ERROR_FILE_PATH_KEY);
        if (StringUtils.isBlank(serviceErrorFilePath)) {
            serviceErrorFilePath = DEFAULT_SERVICE_ERROR_FILE_PATH;
        }
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(serviceErrorFilePath);
        try {
            SERVICE_ERROR_PROPS.load(inputStream);
        } catch (IOException e) {
            throw new ApplicationRuntimeException("load " + serviceErrorFilePath + " file error" , e);
        }

    }

    private ServiceErrorLoader() {}

    /**
     * 加载一个 ServiceError 实例
     * @param name
     * @return
     */
    public static ServiceError loadServiceError(String name) {
        String serviceError = SERVICE_ERROR_PROPS.getProperty(name);
        if (StringUtils.isBlank(serviceError) || StringUtils.containsNone(serviceError , ",")) {
            return null;
        }
        String[] serviceErrorArr = serviceError.split(",");
        return new ServiceError() {
            @Override
            public Integer getErrorCode() {
                return Integer.valueOf(serviceErrorArr[0]);
            }

            @Override
            public String getErrorMsg() {
                return serviceErrorArr[1];
            }

            @Override
            public String toString() {
                return "Error Code [" + getErrorCode() + "] , Error Msg [" + getErrorMsg() + "]";
            }
        };
    }
}
