package org.hepeng.commons.web.util;

import org.hepeng.commons.exception.ApplicationRuntimeException;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;

import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

/**
 * @author he peng
 */
public class HttpResponseUtils {

    private HttpResponseUtils() {}

    public static ServletOutputStream getOutputStreamQuiet(ServletResponse response) {
        Assert.notNull(response , "response == null");
        ServletOutputStream outputStream;
        try {
            outputStream = response.getOutputStream();
        } catch (IOException e) {
            throw new ApplicationRuntimeException(e.getMessage() , e);
        }
        return outputStream;
    }

    public static void writeAndFlushJson(ServletResponse response , String json) {
        Assert.notNull(response , "response == null");
        response.setContentType(MediaType.APPLICATION_JSON_UTF8_VALUE);
        PrintWriter printWriter = new PrintWriter(getOutputStreamQuiet(response));
        printWriter.write(json);
        printWriter.flush();
    }

    public static void writeAndFlushHtml(ServletResponse response , String html) {
        Assert.notNull(response , "response == null");
        response.setContentType(MediaType.TEXT_HTML_VALUE);
        PrintWriter printWriter = new PrintWriter(getOutputStreamQuiet(response));
        printWriter.write(html);
        printWriter.flush();
    }

    public static void writeAndFlushXml(HttpServletResponse response, String xml) {
        Assert.notNull(response , "response == null");
        response.setContentType(MediaType.TEXT_XML_VALUE);
        PrintWriter printWriter = new PrintWriter(getOutputStreamQuiet(response));
        printWriter.write(xml);
        printWriter.flush();
    }
}
