package org.hepeng.commons.web.util;

import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

import javax.servlet.http.HttpSession;
import java.util.Objects;
import java.util.UUID;

/**
 * @author he peng
 */
public class RequestTokenUtils {

    private static final String REQUEST_TOKEN_KEY = "request_token";

    private RequestTokenUtils() {}

    public static String setRequestToken(HttpSession session) {
        Assert.notNull(session , "session == null");
        String token = genToken();
        session.setAttribute(REQUEST_TOKEN_KEY , token);
        return token;
    }

    public static String getRequestToken(HttpSession session) {
        Assert.notNull(session , "session == null");
        Object token = session.getAttribute(REQUEST_TOKEN_KEY);
        return Objects.nonNull(token) ? token.toString() : "";
    }

    public static void removeRequestToken(HttpSession session) {
        Assert.notNull(session , "session == null");
        session.removeAttribute(REQUEST_TOKEN_KEY);
    }

    private static String genToken() {
        return StringUtils.replace(UUID.randomUUID().toString(), "-", "");
    }
}
