package org.hepeng.commons.service;

import java.util.Objects;

/**
 *
 * @author he peng
 */
public class CommonServiceCallResult<E extends ServiceError,D extends Object> implements ServiceCallResult {

    private E error;
    private D data;

    public CommonServiceCallResult() {}

    public CommonServiceCallResult(E error, D data) {
        this.error = error;
        this.data = data;
    }

    /**
     * 返回一个新的 ServiceCallResult 实例对象
     * @param error 错误
     * @param data  数据
     * @param <E>   错误对象类型
     * @param <D>   数据对象类型
     * @return 返回 {@link CommonServiceCallResult} 实例对象
     */
    public static <E extends ServiceError, D extends Object> CommonServiceCallResult newServiceCallResult(E error, D data) {
        return new CommonServiceCallResult(error , data);
    }

    /**
     * 返回一个新的 ServiceCallResult 实例对象
     * @param error 错误
     * @param <E>   错误对象类型
     * @return 返回 {@link CommonServiceCallResult} 实例对象
     */
    public static <E extends ServiceError> CommonServiceCallResult newServiceCallResult(E error) {
        return newServiceCallResult(error , null);
    }

    @Override
    public Boolean isSuccess() {
        if (Objects.equals(this.error.getErrorCode() , ServiceError.SUCCESS.getErrorCode())) {
            return true;
        }
        return false;
    }

    @Override
    public ServiceError getError() {
        return this.error;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public String toString() {
        return "CommonServiceCallResult{" +
                "error=" + error +
                ", data=" + data +
                '}';
    }
}
