package org.hepeng.commons.spring.security;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

import javax.security.auth.Subject;
import java.util.Collection;

/**
 * @author he peng
 */
public class AuthenticationWrapper implements Authentication {

    private Authentication delegate;
    private String source;

    public AuthenticationWrapper(Authentication delegate, String source) {
        this.delegate = delegate;
        this.source = source;
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return delegate.getAuthorities();
    }

    @Override
    public Object getCredentials() {
        return delegate.getCredentials();
    }

    @Override
    public Object getDetails() {
        return delegate.getDetails();
    }

    @Override
    public Object getPrincipal() {
        return delegate.getPrincipal();
    }

    @Override
    public boolean isAuthenticated() {
        return delegate.isAuthenticated();
    }

    @Override
    public void setAuthenticated(boolean b) throws IllegalArgumentException {
        delegate.setAuthenticated(b);
    }

    @Override
    public String getName() {
        return delegate.getName();
    }

    @Override
    public boolean implies(Subject subject) {
        return delegate.implies(subject);
    }

    public Authentication getDelegate() {
        return delegate;
    }

    public void setDelegate(Authentication delegate) {
        this.delegate = delegate;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public String toString() {
        return this.delegate.toString() +
                " AuthenticationWrapper{" +
                "delegate=" + delegate +
                ", source='" + source + '\'' +
                '}';
    }
}
