package org.hepeng.commons.spring.security.filter;

import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;

/**
 * @author he peng
 */
public class APIGatewayRequestSkipOverSpringSecurityChainFilter extends SkipOverSpringSecurityFilterChainFilter {

    @Override
    protected boolean isSkipOver(HttpServletRequest request) {
        String securityContextHeader = request.getHeader("SecurityContext");
        return StringUtils.isNotBlank(securityContextHeader) ? true : false;
    }
}
