package org.hepeng.commons.web.util;

import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

/**
 * @author he peng
 */
public class HttpRequestUtils {

    private HttpRequestUtils() {}

    /**
     * 获取当前 http request
     * @return 返回当前 http 请求中的 {@link HttpServletRequest} 实例
     */
    public static HttpServletRequest getHttpServletRequest() {
         return ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
    }

    /**
     * 判断请求是否是上传文件请求
     * @param request {@link HttpServletRequest} 对象实例
     * @return 返回 true - 是上传文件请求 ， false - 不是上传文件请求
     */
    public static boolean isMultipart(HttpServletRequest request) {
        return ServletFileUpload.isMultipartContent(request);
    }
}
