package org.hepeng.commons.exception;

import org.hepeng.commons.service.ServiceError;

/**
 * 服务异常
 * @author he peng
 */
public class ServiceException extends ApplicationRuntimeException {

    private ServiceError serviceError;

    public ServiceException(String message) {
        super(message);
    }

    public ServiceException(Throwable cause) {
        super(cause);
    }

    public ServiceException(String message, Throwable cause) {
        super(message, cause);
    }

    public ServiceException(ServiceError serviceError) {
        this(serviceError.getErrorMsg());
        this.serviceError = serviceError;
    }

    public ServiceException(String message , ServiceError serviceError) {
        super(message);
        this.serviceError = serviceError;
    }

    public ServiceException(Throwable cause , ServiceError serviceError) {
        super(cause);
        this.serviceError = serviceError;
    }

    public ServiceException(String message, Throwable cause , ServiceError serviceError) {
        super(message, cause);
        this.serviceError = serviceError;
    }

    public ServiceError getServiceError() {
        return serviceError;
    }

    @Override
    public String toString() {
        return "ServiceException{" +
                "serviceError=" + serviceError +
                '}';
    }
}
