package org.hepeng.commons.service;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;

/**
 * @author he peng
 */

@Data
@JsonIgnoreProperties({"error" , "data" , "success"})
public class RestServiceCallResult<E extends ServiceError,D extends Object> extends CommonServiceCallResult {

    private Integer errorCode;
    private String errorMsg;
    private String token;
    private Object entity;

    public RestServiceCallResult() {}

    public RestServiceCallResult(E error, D data) {
        super(error, data);
        this.errorCode = error.getErrorCode();
        this.errorMsg = error.getErrorMsg();
        this.entity = data;
    }

    public static <E extends ServiceError,D extends Object> RestServiceCallResult newRestServiceCallResult(E error, D data) {
        return new RestServiceCallResult(error , data);
    }

    public static RestServiceCallResult newRestServiceCallResult(ServiceCallResult scr) {
        return new RestServiceCallResult(scr.getError() , scr.getData());
    }
}
