package org.hepeng.commons.service;

import java.io.Serializable;

/**
 * 服务错误码顶级接口
 * @author he peng
 */
public interface ServiceError extends Serializable {

    ServiceError SUCCESS = ServiceErrorLoader.loadServiceError("success");
    ServiceError UNKNOWN_ERROR = ServiceErrorLoader.loadServiceError("unknown.error");
    ServiceError PARAMETER_ERROR = ServiceErrorLoader.loadServiceError("parameter.error");
    ServiceError SERVICE_ERROR = ServiceErrorLoader.loadServiceError("service.error");

    /**
     * 获取错误码
     * @return 返回错误码
     */
    Integer getErrorCode();

    /**
     * 获取错误信息
     * @return  返回错误信息
     */
    String getErrorMsg();
}
