package org.hepeng.commons.spring.cloud.netflix.zuul;

import com.netflix.zuul.context.RequestContext;

import java.util.Objects;

import static org.springframework.cloud.netflix.zuul.filters.support.FilterConstants.*;

/**
 * @author he peng
 */
public class RequestContextHelper {

    public static RequestContext getCurrentContext() {
        return RequestContext.getCurrentContext();
    }

    public Object getServiceId() {
        RequestContext ctx = getCurrentContext();
        Object serviceId = ctx.get(SERVICE_ID_KEY);
        if (Objects.isNull(serviceId)) {
            serviceId = ctx.get(PROXY_KEY);
        }
        return serviceId;
    }

    public Object getLoadBalancer() {
        return getCurrentContext().get(LOAD_BALANCER_KEY);
    }

    public Object getRoutePath() {
        return getCurrentContext().get(REQUEST_URI_KEY);
    }
}
