package org.hepeng.commons.spring.cloud.netflix.zuul.filter;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import org.apache.commons.codec.binary.Base64;
import org.hepeng.commons.serializer.ObjectSerializationUtils;
import org.hepeng.commons.serializer.ObjectSerializer;
import org.hepeng.commons.serializer.SupportSerializer;
import org.hepeng.commons.spring.cloud.netflix.zuul.RequestContextHelper;
import org.springframework.cloud.netflix.zuul.filters.support.FilterConstants;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

import java.util.Objects;

/**
 * @author he peng
 */
public class TransferSecurityContextFilter extends ZuulFilter {

//    private ObjectSerializer<SecurityContext> objectSerializer;
    private RedisSerializer redisSerializer = new JdkSerializationRedisSerializer();
    private int filterOrder;

    public TransferSecurityContextFilter(int filterOrder) {
        this.filterOrder = filterOrder;
//        this.objectSerializer = ObjectSerializationUtils.newObjectSerializer(SupportSerializer.HESSIAN , SecurityContext.class);
    }

//    public TransferSecurityContextFilter(int filterOrder , ObjectSerializer objectSerializer) {
//        this(filterOrder);
//        this.objectSerializer = objectSerializer;
//    }

    @Override
    public String filterType() {
        return FilterConstants.PRE_TYPE;
    }

    @Override
    public int filterOrder() {
        return this.filterOrder;
    }

    @Override
    public boolean shouldFilter() {
        return true;
    }

    @Override
    public Object run() throws ZuulException {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (Objects.nonNull(securityContext)) {
            Authentication auth = securityContext.getAuthentication();
            boolean isAuthenticated = Objects.nonNull(auth)
                    && ! AnonymousAuthenticationToken.class.isAssignableFrom(auth.getClass())
                    && auth.isAuthenticated();
            if (isAuthenticated) {
                RequestContext ctx = RequestContextHelper.getCurrentContext();
//                String headerVal = this.objectSerializer.serializeBase64String(securityContext);
                byte[] bytes = this.redisSerializer.serialize(securityContext);
                String headerVal = Base64.encodeBase64String(bytes);
                ctx.addZuulRequestHeader("UpstreamSecurityContext" , headerVal);
            }
        }
        return null;
    }
}
