/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.entity;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.AssertionFailedError;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.test.cache.infinispan.entity.AbstractEntityRegionAccessStrategyTestCase;
import org.infinispan.transaction.tm.BatchModeTransactionManager;
import org.jboss.logging.Logger;
import org.junit.Assert;

public abstract class AbstractTransactionalAccessTestCase
extends AbstractEntityRegionAccessStrategyTestCase {
    private static final Logger log = Logger.getLogger(AbstractTransactionalAccessTestCase.class);

    @Override
    protected AccessType getAccessType() {
        return AccessType.TRANSACTIONAL;
    }

    public void testContestedPutFromLoad() throws Exception {
        final String KEY = "KEY" + testCount++;
        this.localAccessStrategy.putFromLoad((Object)KEY, (Object)"VALUE1", System.currentTimeMillis(), (Object)new Integer(1));
        final CountDownLatch pferLatch = new CountDownLatch(1);
        final CountDownLatch pferCompletionLatch = new CountDownLatch(1);
        final CountDownLatch commitLatch = new CountDownLatch(1);
        final CountDownLatch completionLatch = new CountDownLatch(1);
        Thread blocker = new Thread("Blocker"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    long txTimestamp = System.currentTimeMillis();
                    BatchModeTransactionManager.getInstance().begin();
                    Assert.assertEquals((String)"Correct initial value", (Object)"VALUE1", (Object)AbstractTransactionalAccessTestCase.this.localAccessStrategy.get((Object)KEY, txTimestamp));
                    AbstractTransactionalAccessTestCase.this.localAccessStrategy.update((Object)KEY, (Object)"VALUE2", (Object)new Integer(2), (Object)new Integer(1));
                    pferLatch.countDown();
                    commitLatch.await();
                    BatchModeTransactionManager.getInstance().commit();
                }
                catch (Exception e) {
                    log.error((Object)"node1 caught exception", (Throwable)e);
                    AbstractTransactionalAccessTestCase.this.node1Exception = e;
                    AbstractTransactionalAccessTestCase.this.rollback();
                }
                catch (AssertionFailedError e) {
                    AbstractTransactionalAccessTestCase.this.node1Failure = e;
                    AbstractTransactionalAccessTestCase.this.rollback();
                }
                finally {
                    completionLatch.countDown();
                }
            }
        };
        Thread putter = new Thread("Putter"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    long txTimestamp = System.currentTimeMillis();
                    BatchModeTransactionManager.getInstance().begin();
                    AbstractTransactionalAccessTestCase.this.localAccessStrategy.putFromLoad((Object)KEY, (Object)"VALUE1", txTimestamp, (Object)new Integer(1));
                    BatchModeTransactionManager.getInstance().commit();
                }
                catch (Exception e) {
                    log.error((Object)"node1 caught exception", (Throwable)e);
                    AbstractTransactionalAccessTestCase.this.node1Exception = e;
                    AbstractTransactionalAccessTestCase.this.rollback();
                }
                catch (AssertionFailedError e) {
                    AbstractTransactionalAccessTestCase.this.node1Failure = e;
                    AbstractTransactionalAccessTestCase.this.rollback();
                }
                finally {
                    pferCompletionLatch.countDown();
                }
            }
        };
        blocker.start();
        Assert.assertTrue((String)"Active tx has done an update", (boolean)pferLatch.await(1L, TimeUnit.SECONDS));
        putter.start();
        Assert.assertTrue((String)"putFromLoadreturns promtly", (boolean)pferCompletionLatch.await(10L, TimeUnit.MILLISECONDS));
        commitLatch.countDown();
        Assert.assertTrue((String)"Threads completed", (boolean)completionLatch.await(1L, TimeUnit.SECONDS));
        this.assertThreadsRanCleanly();
        long txTimestamp = System.currentTimeMillis();
        Assert.assertEquals((String)"Correct node1 value", (Object)"VALUE2", (Object)this.localAccessStrategy.get((Object)KEY, txTimestamp));
    }
}

