/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.functional.classloader;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import javax.transaction.TransactionManager;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.test.cache.infinispan.functional.classloader.Account;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClassLoaderTestDAO {
    private static final Log log = LogFactory.getLog(ClassLoaderTestDAO.class);
    private SessionFactory sessionFactory;
    private TransactionManager tm;
    private Class acctClass;
    private Class holderClass;
    private Method setId;
    private Method setBalance;
    private Method setBranch;
    private Method setHolder;
    private Object smith;
    private Object jones;
    private Object barney;
    private Method setName;
    private Method setSsn;

    public ClassLoaderTestDAO(SessionFactory factory, TransactionManager tm) throws Exception {
        this.sessionFactory = factory;
        this.tm = tm;
        this.acctClass = Thread.currentThread().getContextClassLoader().loadClass(this.getClass().getPackage().getName() + ".Account");
        this.holderClass = Thread.currentThread().getContextClassLoader().loadClass(this.getClass().getPackage().getName() + ".AccountHolder");
        this.setId = this.acctClass.getMethod("setId", Integer.class);
        this.setBalance = this.acctClass.getMethod("setBalance", Integer.class);
        this.setBranch = this.acctClass.getMethod("setBranch", String.class);
        this.setHolder = this.acctClass.getMethod("setAccountHolder", this.holderClass);
        this.setName = this.holderClass.getMethod("setLastName", String.class);
        this.setSsn = this.holderClass.getMethod("setSsn", String.class);
        this.smith = this.holderClass.newInstance();
        this.setName.invoke(this.smith, "Smith");
        this.setSsn.invoke(this.smith, "1000");
        this.jones = this.holderClass.newInstance();
        this.setName.invoke(this.jones, "Jones");
        this.setSsn.invoke(this.jones, "2000");
        this.barney = this.holderClass.newInstance();
        this.setName.invoke(this.barney, "Barney");
        this.setSsn.invoke(this.barney, "3000");
    }

    public Object getSmith() {
        return this.smith;
    }

    public Object getJones() {
        return this.jones;
    }

    public Object getBarney() {
        return this.barney;
    }

    public void updateAccountBranch(Integer id, String branch) throws Exception {
        log.debug((Object)("Updating account " + id + " to branch " + branch));
        this.tm.begin();
        try {
            Session session = this.sessionFactory.getCurrentSession();
            Object account = session.get(this.acctClass, (Serializable)id);
            log.debug((Object)("Set branch " + branch));
            this.setBranch.invoke(account, branch);
            session.update(account);
            this.tm.commit();
        }
        catch (Exception e) {
            log.error((Object)"rolling back", (Throwable)e);
            this.tm.rollback();
            throw e;
        }
        log.debug((Object)("Updated account " + id + " to branch " + branch));
    }

    public int getCountForBranch(String branch, boolean useRegion) throws Exception {
        this.tm.begin();
        try {
            Query query = this.sessionFactory.getCurrentSession().createQuery("select account from Account as account where account.branch = :branch");
            query.setString("branch", branch);
            if (useRegion) {
                query.setCacheRegion("AccountRegion");
            }
            query.setCacheable(true);
            int result = query.list().size();
            this.tm.commit();
            return result;
        }
        catch (Exception e) {
            log.error((Object)"rolling back", (Throwable)e);
            this.tm.rollback();
            throw e;
        }
    }

    public void createAccount(Object holder, Integer id, Integer openingBalance, String branch) throws Exception {
        log.debug((Object)("Creating account " + id));
        this.tm.begin();
        try {
            Object account = this.acctClass.newInstance();
            this.setId.invoke(account, id);
            this.setHolder.invoke(account, holder);
            this.setBalance.invoke(account, openingBalance);
            log.debug((Object)("Set branch " + branch));
            this.setBranch.invoke(account, branch);
            this.sessionFactory.getCurrentSession().persist(account);
            this.tm.commit();
        }
        catch (Exception e) {
            log.error((Object)"rolling back", (Throwable)e);
            this.tm.rollback();
            throw e;
        }
        log.debug((Object)("Created account " + id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Account getAccount(Integer id) throws Exception {
        log.debug((Object)("Getting account " + id));
        Session session = this.sessionFactory.openSession();
        try {
            Account account = (Account)session.get(this.acctClass, (Serializable)id);
            return account;
        }
        finally {
            session.close();
        }
    }

    public Account getAccountWithRefresh(Integer id) throws Exception {
        log.debug((Object)("Getting account " + id + " with refresh"));
        this.tm.begin();
        try {
            Session session = this.sessionFactory.getCurrentSession();
            Account acct = (Account)session.get(this.acctClass, (Serializable)id);
            session.refresh((Object)acct);
            acct = (Account)session.get(this.acctClass, (Serializable)id);
            this.tm.commit();
            return acct;
        }
        catch (Exception e) {
            log.error((Object)"rolling back", (Throwable)e);
            this.tm.rollback();
            throw e;
        }
    }

    public void updateAccountBalance(Integer id, Integer newBalance) throws Exception {
        log.debug((Object)("Updating account " + id + " to balance " + newBalance));
        this.tm.begin();
        try {
            Session session = this.sessionFactory.getCurrentSession();
            Object account = session.get(this.acctClass, (Serializable)id);
            this.setBalance.invoke(account, newBalance);
            session.update(account);
            this.tm.commit();
        }
        catch (Exception e) {
            log.error((Object)"rolling back", (Throwable)e);
            this.tm.rollback();
            throw e;
        }
        log.debug((Object)("Updated account " + id + " to balance " + newBalance));
    }

    public String getBranch(Object holder, boolean useRegion) throws Exception {
        this.tm.begin();
        try {
            Query query = this.sessionFactory.getCurrentSession().createQuery("select account.branch from Account as account where account.accountHolder = ?");
            query.setParameter(0, holder);
            if (useRegion) {
                query.setCacheRegion("AccountRegion");
            }
            query.setCacheable(true);
            String result = (String)query.list().get(0);
            this.tm.commit();
            return result;
        }
        catch (Exception e) {
            log.error((Object)"rolling back", (Throwable)e);
            this.tm.rollback();
            throw e;
        }
    }

    public int getTotalBalance(Object holder, boolean useRegion) throws Exception {
        List results = null;
        this.tm.begin();
        try {
            Query query = this.sessionFactory.getCurrentSession().createQuery("select account.balance from Account as account where account.accountHolder = ?");
            query.setParameter(0, holder);
            if (useRegion) {
                query.setCacheRegion("AccountRegion");
            }
            query.setCacheable(true);
            results = query.list();
            this.tm.commit();
        }
        catch (Exception e) {
            log.error((Object)"rolling back", (Throwable)e);
            this.tm.rollback();
            throw e;
        }
        int total = 0;
        if (results != null) {
            Iterator it = results.iterator();
            while (it.hasNext()) {
                System.out.println("Total = " + (total += ((Integer)it.next()).intValue()));
            }
        }
        return total;
    }

    public void cleanup() throws Exception {
        this.internalCleanup();
    }

    private void internalCleanup() throws Exception {
        if (this.sessionFactory != null) {
            this.tm.begin();
            try {
                Session session = this.sessionFactory.getCurrentSession();
                Query query = session.createQuery("select account from Account as account");
                List accts = query.list();
                if (accts != null) {
                    Iterator it = accts.iterator();
                    while (it.hasNext()) {
                        try {
                            Object acct = it.next();
                            log.info((Object)("Removing " + acct));
                            session.delete(acct);
                        }
                        catch (Exception ignored) {}
                    }
                }
                this.tm.commit();
            }
            catch (Exception e) {
                this.tm.rollback();
                throw e;
            }
        }
    }

    public void remove() {
        try {
            this.internalCleanup();
        }
        catch (Exception e) {
            log.error((Object)"Caught exception in remove", (Throwable)e);
        }
    }
}

