/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan;

import java.util.Map;
import java.util.Properties;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TransactionalDataRegion;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.test.cache.infinispan.AbstractRegionImplTestCase;
import org.hibernate.test.cache.infinispan.util.CacheTestUtil;
import org.hibernate.testing.ServiceRegistryBuilder;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractEntityCollectionRegionTestCase
extends AbstractRegionImplTestCase {
    @Test
    public void testSupportedAccessTypes() throws Exception {
        this.supportedAccessTypeTest();
    }

    private void supportedAccessTypeTest() throws Exception {
        Configuration cfg = CacheTestUtil.buildConfiguration("test", InfinispanRegionFactory.class, true, false);
        String entityCfg = "entity";
        cfg.setProperty("hibernate.cache.infinispan.entity.cfg", entityCfg);
        InfinispanRegionFactory regionFactory = CacheTestUtil.startRegionFactory((ServiceRegistry)ServiceRegistryBuilder.buildServiceRegistry((Map)cfg.getProperties()), cfg, this.getCacheTestSupport());
        this.supportedAccessTypeTest((RegionFactory)regionFactory, cfg.getProperties());
    }

    protected abstract void supportedAccessTypeTest(RegionFactory var1, Properties var2);

    @Test
    public void testIsTransactionAware() throws Exception {
        Configuration cfg = CacheTestUtil.buildConfiguration("test", InfinispanRegionFactory.class, true, false);
        InfinispanRegionFactory regionFactory = CacheTestUtil.startRegionFactory((ServiceRegistry)ServiceRegistryBuilder.buildServiceRegistry((Map)cfg.getProperties()), cfg, this.getCacheTestSupport());
        TransactionalDataRegion region = (TransactionalDataRegion)this.createRegion(regionFactory, "test/test", cfg.getProperties(), this.getCacheDataDescription());
        Assert.assertTrue((String)"Region is transaction-aware", (boolean)region.isTransactionAware());
        CacheTestUtil.stopRegionFactory(regionFactory, this.getCacheTestSupport());
    }

    @Test
    public void testGetCacheDataDescription() throws Exception {
        Configuration cfg = CacheTestUtil.buildConfiguration("test", InfinispanRegionFactory.class, true, false);
        InfinispanRegionFactory regionFactory = CacheTestUtil.startRegionFactory((ServiceRegistry)ServiceRegistryBuilder.buildServiceRegistry((Map)cfg.getProperties()), cfg, this.getCacheTestSupport());
        TransactionalDataRegion region = (TransactionalDataRegion)this.createRegion(regionFactory, "test/test", cfg.getProperties(), this.getCacheDataDescription());
        CacheDataDescription cdd = region.getCacheDataDescription();
        Assert.assertNotNull((Object)cdd);
        CacheDataDescription expected = this.getCacheDataDescription();
        Assert.assertEquals((Object)expected.isMutable(), (Object)cdd.isMutable());
        Assert.assertEquals((Object)expected.isVersioned(), (Object)cdd.isVersioned());
        Assert.assertEquals((Object)expected.getVersionComparator(), (Object)cdd.getVersionComparator());
    }
}

