/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate5.management;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.persistence.EntityManagerFactory;
import org.hibernate.SessionFactory;
import org.hibernate.stat.CollectionStatistics;
import org.hibernate.stat.Statistics;
import org.jboss.as.jpa.hibernate5.management.HibernateAbstractStatistics;
import org.jipijapa.management.spi.EntityManagerFactoryAccess;
import org.jipijapa.management.spi.Operation;
import org.jipijapa.management.spi.PathAddress;

public class HibernateCollectionStatistics
extends HibernateAbstractStatistics {
    private static final String ATTRIBUTE_COLLECTION_NAME = "collection-name";
    public static final String OPERATION_COLLECTION_LOAD_COUNT = "collection-load-count";
    public static final String OPERATION_COLLECTION_FETCH_COUNT = "collection-fetch-count";
    public static final String OPERATION_COLLECTION_UPDATE_COUNT = "collection-update-count";
    public static final String OPERATION_COLLECTION_REMOVE_COUNT = "collection-remove-count";
    public static final String OPERATION_COLLECTION_RECREATED_COUNT = "collection-recreated-count";
    private Operation showCollectionName = new Operation(){

        public Object invoke(Object ... args) {
            return HibernateCollectionStatistics.this.getStatisticName(args);
        }
    };
    private Operation collectionUpdateCount = new Operation(){

        public Object invoke(Object ... args) {
            CollectionStatistics statistics = HibernateCollectionStatistics.this.getStatistics(HibernateCollectionStatistics.this.getEntityManagerFactory(args), HibernateCollectionStatistics.this.getStatisticName(args));
            return statistics != null ? statistics.getUpdateCount() : 0L;
        }
    };
    private Operation collectionRemoveCount = new Operation(){

        public Object invoke(Object ... args) {
            CollectionStatistics statistics = HibernateCollectionStatistics.this.getStatistics(HibernateCollectionStatistics.this.getEntityManagerFactory(args), HibernateCollectionStatistics.this.getStatisticName(args));
            return statistics != null ? statistics.getRemoveCount() : 0L;
        }
    };
    private Operation collectionRecreatedCount = new Operation(){

        public Object invoke(Object ... args) {
            CollectionStatistics statistics = HibernateCollectionStatistics.this.getStatistics(HibernateCollectionStatistics.this.getEntityManagerFactory(args), HibernateCollectionStatistics.this.getStatisticName(args));
            return statistics != null ? statistics.getRemoveCount() : 0L;
        }
    };
    private Operation collectionLoadCount = new Operation(){

        public Object invoke(Object ... args) {
            CollectionStatistics statistics = HibernateCollectionStatistics.this.getStatistics(HibernateCollectionStatistics.this.getEntityManagerFactory(args), HibernateCollectionStatistics.this.getStatisticName(args));
            return statistics != null ? statistics.getLoadCount() : 0L;
        }
    };
    private Operation collectionFetchCount = new Operation(){

        public Object invoke(Object ... args) {
            CollectionStatistics statistics = HibernateCollectionStatistics.this.getStatistics(HibernateCollectionStatistics.this.getEntityManagerFactory(args), HibernateCollectionStatistics.this.getStatisticName(args));
            return statistics != null ? statistics.getFetchCount() : 0L;
        }
    };

    public HibernateCollectionStatistics() {
        this.getOperations().put(ATTRIBUTE_COLLECTION_NAME, this.showCollectionName);
        this.getTypes().put(ATTRIBUTE_COLLECTION_NAME, String.class);
        this.getOperations().put(OPERATION_COLLECTION_LOAD_COUNT, this.collectionLoadCount);
        this.getTypes().put(OPERATION_COLLECTION_LOAD_COUNT, Long.class);
        this.getOperations().put(OPERATION_COLLECTION_FETCH_COUNT, this.collectionFetchCount);
        this.getTypes().put(OPERATION_COLLECTION_FETCH_COUNT, Long.class);
        this.getOperations().put(OPERATION_COLLECTION_UPDATE_COUNT, this.collectionUpdateCount);
        this.getTypes().put(OPERATION_COLLECTION_UPDATE_COUNT, Long.class);
        this.getOperations().put(OPERATION_COLLECTION_REMOVE_COUNT, this.collectionRemoveCount);
        this.getTypes().put(OPERATION_COLLECTION_REMOVE_COUNT, Long.class);
        this.getOperations().put(OPERATION_COLLECTION_RECREATED_COUNT, this.collectionRecreatedCount);
        this.getTypes().put(OPERATION_COLLECTION_RECREATED_COUNT, Long.class);
    }

    public Collection<String> getDynamicChildrenNames(EntityManagerFactoryAccess entityManagerFactoryLookup, PathAddress pathAddress) {
        Statistics stats = this.getBaseStatistics(entityManagerFactoryLookup.entityManagerFactory(pathAddress.getValue("hibernate-persistence-unit")));
        if (stats == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(Arrays.asList(stats.getCollectionRoleNames()));
    }

    private Statistics getBaseStatistics(EntityManagerFactory entityManagerFactory) {
        if (entityManagerFactory == null) {
            return null;
        }
        SessionFactory sessionFactory = (SessionFactory)entityManagerFactory.unwrap(SessionFactory.class);
        if (sessionFactory != null) {
            return sessionFactory.getStatistics();
        }
        return null;
    }

    private CollectionStatistics getStatistics(EntityManagerFactory entityManagerFactory, String collectionName) {
        if (entityManagerFactory == null) {
            return null;
        }
        SessionFactory sessionFactory = (SessionFactory)entityManagerFactory.unwrap(SessionFactory.class);
        if (sessionFactory != null) {
            return sessionFactory.getStatistics().getCollectionStatistics(collectionName);
        }
        return null;
    }
}

