/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.osgi;

import java.io.DataInputStream;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import org.hibernate.ejb.packaging.NamedInputStream;
import org.hibernate.ejb.packaging.Scanner;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class OsgiScanner
implements Scanner {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)OsgiScanner.class.getName());
    private BundleWiring bundleWiring;
    private Bundle persistenceBundle;

    public OsgiScanner(Bundle persistenceBundle) {
        this.persistenceBundle = persistenceBundle;
        this.bundleWiring = (BundleWiring)persistenceBundle.adapt(BundleWiring.class);
    }

    public Set<Package> getPackagesInJar(URL jartoScan, Set<Class<? extends Annotation>> annotationsToLookFor) {
        return Collections.EMPTY_SET;
    }

    public Set<Class<?>> getClassesInJar(URL jartoScan, Set<Class<? extends Annotation>> annotationsToLookFor) {
        HashSet classes = new HashSet();
        Collection classNames = this.bundleWiring.listResources("/", "*.class", 1);
        for (String className : classNames) {
            try {
                URL classUrl = this.persistenceBundle.getResource(className);
                InputStream is = classUrl.openStream();
                DataInputStream dis = new DataInputStream(is);
                ClassFile cf = new ClassFile(dis);
                AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
                if (visible != null) {
                    for (Class<? extends Annotation> annotation : annotationsToLookFor) {
                        if (visible.getAnnotation(annotation.getName()) == null) continue;
                        classes.add(this.persistenceBundle.loadClass(cf.getName()));
                        break;
                    }
                }
                dis.close();
                is.close();
            }
            catch (Exception e) {
                LOG.unableToLoadScannedClassOrResource(e);
            }
        }
        return classes;
    }

    public Set<NamedInputStream> getFilesInJar(URL jartoScan, Set<String> filePatterns) {
        HashSet<NamedInputStream> files = new HashSet<NamedInputStream>();
        for (String filePattern : filePatterns) {
            filePattern = filePattern.replaceAll("(.*/)*", "");
            Collection resources = this.bundleWiring.listResources("/", filePattern, 1);
            for (String resource : resources) {
                try {
                    files.add(new NamedInputStream(resource, this.persistenceBundle.getResource(resource).openStream()));
                }
                catch (Exception e) {
                    LOG.unableToLoadScannedClassOrResource(e);
                }
            }
        }
        return files;
    }

    public Set<NamedInputStream> getFilesInClasspath(Set<String> filePatterns) {
        return null;
    }

    public String getUnqualifiedJarName(URL jarUrl) {
        return null;
    }
}

