/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.nulls.impl;

import org.hibernate.search.bridge.spi.NullMarker;
import org.hibernate.search.engine.metadata.impl.PartialDocumentFieldMetadata;
import org.hibernate.search.engine.nulls.codec.impl.LuceneDoubleNullMarkerCodec;
import org.hibernate.search.engine.nulls.codec.impl.LuceneFloatNullMarkerCodec;
import org.hibernate.search.engine.nulls.codec.impl.LuceneIntegerNullMarkerCodec;
import org.hibernate.search.engine.nulls.codec.impl.LuceneLongNullMarkerCodec;
import org.hibernate.search.engine.nulls.codec.impl.LuceneStringNullMarkerCodec;
import org.hibernate.search.engine.nulls.codec.impl.NullMarkerCodec;
import org.hibernate.search.engine.nulls.impl.MissingValueStrategy;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class LuceneMissingValueStrategy
implements MissingValueStrategy {
    private static final Log LOG = LoggerFactory.make(Log.class);
    public static final LuceneMissingValueStrategy INSTANCE = new LuceneMissingValueStrategy();

    private LuceneMissingValueStrategy() {
    }

    @Override
    public NullMarkerCodec createNullMarkerCodec(IndexedTypeIdentifier entityType, PartialDocumentFieldMetadata fieldMetadata, NullMarker nullMarker) {
        Object nullEncoded = nullMarker.nullEncoded();
        if (nullEncoded instanceof String) {
            return new LuceneStringNullMarkerCodec(nullMarker);
        }
        if (nullEncoded instanceof Integer) {
            return new LuceneIntegerNullMarkerCodec(nullMarker);
        }
        if (nullEncoded instanceof Long) {
            return new LuceneLongNullMarkerCodec(nullMarker);
        }
        if (nullEncoded instanceof Float) {
            return new LuceneFloatNullMarkerCodec(nullMarker);
        }
        if (nullEncoded instanceof Double) {
            return new LuceneDoubleNullMarkerCodec(nullMarker);
        }
        throw LOG.unsupportedNullTokenType(entityType, fieldMetadata.getPath().getAbsoluteName(), nullEncoded.getClass());
    }
}

