/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.backend.configuration.impl.IndexWriterSetting;
import org.hibernate.search.backend.spi.LuceneIndexingParameters;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.test.SearchTestBase;
import org.junit.Assert;
import org.junit.Before;

public abstract class ConfigurationReadTestCase
extends SearchTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        fullTextSession.close();
    }

    protected final void assertValueIsDefault(Class testEntity, IndexWriterSetting setting) {
        this.assertValueIsDefault(testEntity, 0, setting);
    }

    protected final void assertValueIsDefault(Class testEntity, int shard, IndexWriterSetting setting) {
        Assert.assertNull((String)("shard:" + shard + " setting:" + setting.getKey() + " : value was expected unset!"), (Object)this.getParameter(shard, setting, testEntity));
    }

    protected final void assertValueIsSet(Class testEntity, IndexWriterSetting setting, int expectedValue) {
        this.assertValueIsSet(testEntity, 0, setting, expectedValue);
    }

    protected final void assertValueIsSet(Class testEntity, int shard, IndexWriterSetting setting, int expectedValue) {
        Assert.assertNotNull((String)("shard:" + shard + " setting:" + setting.getKey()), (Object)this.getParameter(shard, setting, testEntity));
        Assert.assertEquals((String)("shard:" + shard + " setting:" + setting.getKey()), (long)expectedValue, (long)this.getParameter(shard, setting, testEntity).intValue());
    }

    private Integer getParameter(int shard, IndexWriterSetting setting, Class testEntity) {
        EntityIndexBinding mappingForEntity = this.getExtendedSearchIntegrator().getIndexBinding(testEntity);
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)mappingForEntity.getIndexManagers()[shard];
        LuceneIndexingParameters luceneIndexingParameters = indexManager.getIndexingParameters();
        return luceneIndexingParameters.getIndexParameters().getCurrentValueFor(setting);
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.indexBase", this.getBaseIndexDir().getAbsolutePath());
    }

    public static void assertCfgIsInvalid(Configuration configuration, Class[] mapping) {
        try {
            for (Class annotated : mapping) {
                configuration.addAnnotatedClass(annotated);
            }
            configuration.setProperty("hibernate.search.default.directory_provider", "ram");
            configuration.buildSessionFactory();
            Assert.fail();
        }
        catch (HibernateException e) {
            Throwable cause = e.getCause();
            Assert.assertTrue((boolean)(cause instanceof SearchException));
        }
    }
}

