/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine;

import java.io.Serializable;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

public class TransientFieldsDirtyTest
extends SearchTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestForIssue(jiraKey="HSEARCH-1096")
    @Test
    public void testTransientFieldsAreAlwaysDirty() {
        try (Session session = this.openSession();){
            FormulaAdd f = new FormulaAdd();
            f.id = 1L;
            f.a = 1;
            f.b = 2;
            Transaction transaction = session.beginTransaction();
            session.persist((Object)f);
            transaction.commit();
            session.clear();
            this.assertFormulaMatches("3", session);
            transaction = session.beginTransaction();
            FormulaAdd loadedFormula = (FormulaAdd)session.load(FormulaAdd.class, (Serializable)Long.valueOf(1L));
            loadedFormula.a = 3;
            transaction.commit();
            session.clear();
            this.assertFormulaMatches("5", session);
        }
    }

    private void assertFormulaMatches(String value, Session session) {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        Transaction transaction = session.beginTransaction();
        QueryBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(FormulaAdd.class).get();
        Query luceneQuery = ((TermMatchingContext)queryBuilder.keyword().onField("aplusB").ignoreAnalyzer()).matching((Object)value).createQuery();
        FullTextQuery query = fullTextSession.createFullTextQuery(luceneQuery, new Class[]{FormulaAdd.class});
        List resultsList = query.list();
        transaction.commit();
        Assert.assertEquals((long)1L, (long)resultsList.size());
        FormulaAdd result = (FormulaAdd)resultsList.get(0);
        Assert.assertEquals((Object)value, (Object)result.getAplusB());
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{FormulaAdd.class};
    }

    @Indexed
    @Entity
    @Table(name="FORMULAADD")
    public static class FormulaAdd {
        long id;
        int a;
        int b;

        @Id
        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public int getA() {
            return this.a;
        }

        public void setA(int a) {
            this.a = a;
        }

        public int getB() {
            return this.b;
        }

        public void setB(int b) {
            this.b = b;
        }

        @Transient
        @Field(analyze=Analyze.NO)
        public String getAplusB() {
            return "" + (this.a + this.b);
        }
    }
}

