/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.WorkVisitor;
import org.hibernate.search.backend.impl.lucene.DpSelectionDelegate;
import org.hibernate.search.backend.impl.lucene.PerDirectoryWorkProcessor;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.IndexShardingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DpSelectionVisitor
implements WorkVisitor<DpSelectionDelegate> {
    private final AddSelectionDelegate addDelegate = new AddSelectionDelegate();
    private final DeleteSelectionDelegate deleteDelegate = new DeleteSelectionDelegate();
    private final OptimizeSelectionDelegate optimizeDelegate = new OptimizeSelectionDelegate();
    private final PurgeAllSelectionDelegate purgeDelegate = new PurgeAllSelectionDelegate();

    @Override
    public DpSelectionDelegate getDelegate(AddLuceneWork addLuceneWork) {
        return this.addDelegate;
    }

    @Override
    public DpSelectionDelegate getDelegate(DeleteLuceneWork deleteLuceneWork) {
        return this.deleteDelegate;
    }

    @Override
    public DpSelectionDelegate getDelegate(OptimizeLuceneWork optimizeLuceneWork) {
        return this.optimizeDelegate;
    }

    @Override
    public DpSelectionDelegate getDelegate(PurgeAllLuceneWork purgeAllLuceneWork) {
        return this.purgeDelegate;
    }

    private static class PurgeAllSelectionDelegate
    implements DpSelectionDelegate {
        private PurgeAllSelectionDelegate() {
        }

        public void addAsPayLoadsToQueue(LuceneWork work, IndexShardingStrategy shardingStrategy, PerDirectoryWorkProcessor queues) throws InterruptedException {
            DirectoryProvider<?>[] providers;
            for (DirectoryProvider<?> provider : providers = shardingStrategy.getDirectoryProvidersForDeletion(work.getEntityClass(), work.getId(), work.getIdInString())) {
                queues.addWorkToDpProcessor(provider, work);
            }
        }
    }

    private static class OptimizeSelectionDelegate
    implements DpSelectionDelegate {
        private OptimizeSelectionDelegate() {
        }

        public void addAsPayLoadsToQueue(LuceneWork work, IndexShardingStrategy shardingStrategy, PerDirectoryWorkProcessor queues) throws InterruptedException {
            DirectoryProvider<?>[] providers;
            for (DirectoryProvider<?> provider : providers = shardingStrategy.getDirectoryProvidersForAllShards()) {
                queues.addWorkToDpProcessor(provider, work);
            }
        }
    }

    private static class DeleteSelectionDelegate
    implements DpSelectionDelegate {
        private DeleteSelectionDelegate() {
        }

        public void addAsPayLoadsToQueue(LuceneWork work, IndexShardingStrategy shardingStrategy, PerDirectoryWorkProcessor queues) throws InterruptedException {
            DirectoryProvider<?>[] providers;
            for (DirectoryProvider<?> provider : providers = shardingStrategy.getDirectoryProvidersForDeletion(work.getEntityClass(), work.getId(), work.getIdInString())) {
                queues.addWorkToDpProcessor(provider, work);
            }
        }
    }

    private static class AddSelectionDelegate
    implements DpSelectionDelegate {
        private AddSelectionDelegate() {
        }

        public void addAsPayLoadsToQueue(LuceneWork work, IndexShardingStrategy shardingStrategy, PerDirectoryWorkProcessor queues) throws InterruptedException {
            DirectoryProvider<?> provider = shardingStrategy.getDirectoryProviderForAddition(work.getEntityClass(), work.getId(), work.getIdInString(), work.getDocument());
            queues.addWorkToDpProcessor(provider, work);
        }
    }
}

