/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.util.Map;
import java.util.Properties;
import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.backend.BackendQueueProcessorFactory;
import org.hibernate.search.backend.LuceneIndexingParameters;
import org.hibernate.search.backend.Worker;
import org.hibernate.search.engine.DocumentBuilderContainedEntity;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.FilterDef;
import org.hibernate.search.engine.ServiceManager;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.filter.FilterCachingStrategy;
import org.hibernate.search.reader.ReaderProvider;
import org.hibernate.search.spi.internals.DirectoryProviderData;
import org.hibernate.search.spi.internals.PolymorphicIndexHierarchy;
import org.hibernate.search.spi.internals.SearchFactoryState;
import org.hibernate.search.store.DirectoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableSearchFactoryState
implements SearchFactoryState {
    private Map<Class<?>, DocumentBuilderContainedEntity<?>> documentBuildersContainedEntities;
    private Map<DirectoryProvider<?>, DirectoryProviderData> directoryProviderData;
    private Map<Class<?>, DocumentBuilderIndexedEntity<?>> documentBuildersIndexedEntities;
    private String indexingStrategy;
    private Worker worker;
    private ReaderProvider readerProvider;
    private BackendQueueProcessorFactory backendQueueProcessorFactory;
    private Map<String, FilterDef> filterDefinitions;
    private FilterCachingStrategy filterCachingStrategy;
    private Map<String, Analyzer> analyzers;
    private int cacheBitResultsSize;
    private Properties configurationProperties;
    private ErrorHandler errorHandler;
    private PolymorphicIndexHierarchy indexHierarchy;
    private Map<DirectoryProvider, LuceneIndexingParameters> directoryProviderIndexingParams;
    private ServiceManager serviceManager;

    public void copyStateFromOldFactory(SearchFactoryState oldFactoryState) {
        this.indexingStrategy = oldFactoryState.getIndexingStrategy();
        this.documentBuildersIndexedEntities = oldFactoryState.getDocumentBuildersIndexedEntities();
        this.documentBuildersContainedEntities = oldFactoryState.getDocumentBuildersContainedEntities();
        this.directoryProviderData = oldFactoryState.getDirectoryProviderData();
        this.worker = oldFactoryState.getWorker();
        this.readerProvider = oldFactoryState.getReaderProvider();
        this.backendQueueProcessorFactory = oldFactoryState.getBackendQueueProcessorFactory();
        this.filterDefinitions = oldFactoryState.getFilterDefinitions();
        this.filterCachingStrategy = oldFactoryState.getFilterCachingStrategy();
        this.analyzers = oldFactoryState.getAnalyzers();
        this.cacheBitResultsSize = oldFactoryState.getCacheBitResultsSize();
        this.configurationProperties = oldFactoryState.getConfigurationProperties();
        this.errorHandler = oldFactoryState.getErrorHandler();
        this.indexHierarchy = oldFactoryState.getIndexHierarchy();
        this.directoryProviderIndexingParams = oldFactoryState.getDirectoryProviderIndexingParams();
        this.serviceManager = oldFactoryState.getServiceManager();
    }

    @Override
    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    @Override
    public Map<Class<?>, DocumentBuilderContainedEntity<?>> getDocumentBuildersContainedEntities() {
        return this.documentBuildersContainedEntities;
    }

    @Override
    public Map<DirectoryProvider<?>, DirectoryProviderData> getDirectoryProviderData() {
        return this.directoryProviderData;
    }

    @Override
    public Map<Class<?>, DocumentBuilderIndexedEntity<?>> getDocumentBuildersIndexedEntities() {
        return this.documentBuildersIndexedEntities;
    }

    @Override
    public String getIndexingStrategy() {
        return this.indexingStrategy;
    }

    @Override
    public Worker getWorker() {
        return this.worker;
    }

    @Override
    public ReaderProvider getReaderProvider() {
        return this.readerProvider;
    }

    @Override
    public BackendQueueProcessorFactory getBackendQueueProcessorFactory() {
        return this.backendQueueProcessorFactory;
    }

    @Override
    public Map<String, FilterDef> getFilterDefinitions() {
        return this.filterDefinitions;
    }

    @Override
    public FilterCachingStrategy getFilterCachingStrategy() {
        return this.filterCachingStrategy;
    }

    @Override
    public Map<String, Analyzer> getAnalyzers() {
        return this.analyzers;
    }

    @Override
    public int getCacheBitResultsSize() {
        return this.cacheBitResultsSize;
    }

    @Override
    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public PolymorphicIndexHierarchy getIndexHierarchy() {
        return this.indexHierarchy;
    }

    @Override
    public Map<DirectoryProvider, LuceneIndexingParameters> getDirectoryProviderIndexingParams() {
        return this.directoryProviderIndexingParams;
    }

    public void setDocumentBuildersContainedEntities(Map<Class<?>, DocumentBuilderContainedEntity<?>> documentBuildersContainedEntities) {
        this.documentBuildersContainedEntities = documentBuildersContainedEntities;
    }

    public void setDirectoryProviderData(Map<DirectoryProvider<?>, DirectoryProviderData> directoryProviderData) {
        this.directoryProviderData = directoryProviderData;
    }

    public void setDocumentBuildersIndexedEntities(Map<Class<?>, DocumentBuilderIndexedEntity<?>> documentBuildersIndexedEntities) {
        this.documentBuildersIndexedEntities = documentBuildersIndexedEntities;
    }

    public void setIndexingStrategy(String indexingStrategy) {
        this.indexingStrategy = indexingStrategy;
    }

    public void setWorker(Worker worker) {
        this.worker = worker;
    }

    public void setReaderProvider(ReaderProvider readerProvider) {
        this.readerProvider = readerProvider;
    }

    @Override
    public void setBackendQueueProcessorFactory(BackendQueueProcessorFactory backendQueueProcessorFactory) {
        this.backendQueueProcessorFactory = backendQueueProcessorFactory;
    }

    public void setFilterDefinitions(Map<String, FilterDef> filterDefinitions) {
        this.filterDefinitions = filterDefinitions;
    }

    public void setFilterCachingStrategy(FilterCachingStrategy filterCachingStrategy) {
        this.filterCachingStrategy = filterCachingStrategy;
    }

    public void setAnalyzers(Map<String, Analyzer> analyzers) {
        this.analyzers = analyzers;
    }

    public void setCacheBitResultsSize(int cacheBitResultsSize) {
        this.cacheBitResultsSize = cacheBitResultsSize;
    }

    public void setConfigurationProperties(Properties configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setIndexHierarchy(PolymorphicIndexHierarchy indexHierarchy) {
        this.indexHierarchy = indexHierarchy;
    }

    public void setDirectoryProviderIndexingParams(Map<DirectoryProvider, LuceneIndexingParameters> directoryProviderIndexingParams) {
        this.directoryProviderIndexingParams = directoryProviderIndexingParams;
    }
}

