/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util;

import java.util.HashSet;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNDIHelper {
    private JNDIHelper() {
    }

    public static InitialContext getInitialContext(Properties properties, String prefix) throws NamingException {
        Properties jndiProps = JNDIHelper.getJndiProperties(properties, prefix);
        if (jndiProps.size() == 0) {
            return new InitialContext();
        }
        return new InitialContext(jndiProps);
    }

    public static Properties getJndiProperties(Properties properties, String prefix) {
        HashSet<String> specialProps = new HashSet<String>();
        specialProps.add(prefix + "class");
        specialProps.add(prefix + "url");
        Properties result = JNDIHelper.addJNDIProperties(properties, prefix, specialProps);
        JNDIHelper.handleSpecialPropertyTranslation(properties, prefix + "class", result, "java.naming.factory.initial");
        JNDIHelper.handleSpecialPropertyTranslation(properties, prefix + "url", result, "java.naming.provider.url");
        return result;
    }

    private static Properties addJNDIProperties(Properties properties, String prefix, HashSet<String> specialProps) {
        Properties result = new Properties();
        for (Object property : properties.keySet()) {
            String s;
            if (!(property instanceof String) || (s = (String)property).indexOf(prefix) <= -1 || specialProps.contains(s)) continue;
            result.setProperty(s.substring(prefix.length()), properties.getProperty(s));
        }
        return result;
    }

    private static void handleSpecialPropertyTranslation(Properties originalProperties, String oldKey, Properties newProperties, String newKey) {
        String value = originalProperties.getProperty(oldKey);
        if (value != null) {
            newProperties.put(newKey, value);
        }
    }
}

