/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.hibernate.hql.ast.spi.predicate.ParentPredicate;
import org.hibernate.hql.ast.spi.predicate.Predicate;
import org.hibernate.hql.ast.spi.predicate.PredicateFactory;
import org.hibernate.hql.ast.spi.predicate.RootPredicate;

public class SingleEntityQueryBuilder<Q> {
    private final PredicateFactory<Q> predicateFactory;
    private final PropertyHelper propertyHelper;
    private String entityType;
    private RootPredicate<Q> rootPredicate;
    private final Stack<ParentPredicate<Q>> predicates = new Stack();

    private SingleEntityQueryBuilder(PredicateFactory<Q> predicateFactory, PropertyHelper propertyHelper) {
        this.predicateFactory = predicateFactory;
        this.propertyHelper = propertyHelper;
    }

    public static <Q> SingleEntityQueryBuilder<Q> getInstance(PredicateFactory<Q> predicateFactory, PropertyHelper propertyHelper) {
        return new SingleEntityQueryBuilder<Q>(predicateFactory, propertyHelper);
    }

    public SingleEntityQueryBuilder<Q> setEntityType(String entityType) {
        this.entityType = entityType;
        this.rootPredicate = this.predicateFactory.getRootPredicate(entityType);
        this.predicates.push(this.rootPredicate);
        return this;
    }

    public SingleEntityQueryBuilder<Q> addComparisonPredicate(List<String> propertyPath, ComparisonPredicate.Type comparisonType, Object value) {
        Object typedValue = this.propertyHelper.convertToBackendType(this.entityType, propertyPath, value);
        this.pushPredicate(this.predicateFactory.getComparisonPredicate(this.entityType, comparisonType, propertyPath, typedValue));
        return this;
    }

    public SingleEntityQueryBuilder<Q> addRangePredicate(String property, Object lower, Object upper) {
        return this.addRangePredicate(Arrays.asList(property), lower, upper);
    }

    public SingleEntityQueryBuilder<Q> addRangePredicate(List<String> propertyPath, Object lower, Object upper) {
        Object lowerValue = this.propertyHelper.convertToBackendType(this.entityType, propertyPath, lower);
        Object upperValue = this.propertyHelper.convertToBackendType(this.entityType, propertyPath, upper);
        this.pushPredicate(this.predicateFactory.getRangePredicate(this.entityType, propertyPath, lowerValue, upperValue));
        return this;
    }

    public SingleEntityQueryBuilder<Q> addInPredicate(List<String> propertyPath, List<Object> elements) {
        ArrayList<Object> typedElements = new ArrayList<Object>(elements.size());
        for (Object element : elements) {
            typedElements.add(this.propertyHelper.convertToBackendType(this.entityType, propertyPath, element));
        }
        this.pushPredicate(this.predicateFactory.getInPredicate(this.entityType, propertyPath, typedElements));
        return this;
    }

    public SingleEntityQueryBuilder<Q> addLikePredicate(List<String> propertyPath, String patternValue, Character escapeCharacter) {
        this.pushPredicate(this.predicateFactory.getLikePredicate(this.entityType, propertyPath, patternValue, escapeCharacter));
        return this;
    }

    public SingleEntityQueryBuilder<Q> addIsNullPredicate(List<String> propertyPath) {
        this.pushPredicate(this.predicateFactory.getIsNullPredicate(this.entityType, propertyPath));
        return this;
    }

    public SingleEntityQueryBuilder<Q> pushAndPredicate() {
        this.pushPredicate(this.predicateFactory.getConjunctionPredicate());
        return this;
    }

    public SingleEntityQueryBuilder<Q> pushOrPredicate() {
        this.pushPredicate(this.predicateFactory.getDisjunctionPredicate());
        return this;
    }

    public SingleEntityQueryBuilder<Q> pushNotPredicate() {
        this.pushPredicate(this.predicateFactory.getNegationPredicate());
        return this;
    }

    private void pushPredicate(Predicate<Q> predicate) {
        this.predicates.peek().add(predicate);
        if (predicate.getType().isParent()) {
            ParentPredicate parentPredicate = predicate.as(ParentPredicate.class);
            this.predicates.push(parentPredicate);
        }
    }

    public SingleEntityQueryBuilder<Q> popBooleanPredicate() {
        this.predicates.pop();
        return this;
    }

    public Q build() {
        return this.rootPredicate.getQuery();
    }

    public String toString() {
        return "SingleEntityQueryBuilder [entityType=" + this.entityType + ", rootPredicate=" + this.rootPredicate + "]";
    }
}

