// $Id: TCKValidationProvider.java 16791 2009-06-16 10:50:53Z hardy.ferentschik $
/*
* JBoss, Home of Professional Open Source
* Copyright 2008, Red Hat Middleware LLC, and individual contributors
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
* http://www.apache.org/licenses/LICENSE-2.0
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
package org.hibernate.jsr303.tck.tests.bootstrap.customprovider;

import javax.validation.Configuration;
import javax.validation.MessageInterpolator;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import javax.validation.spi.BootstrapState;
import javax.validation.spi.ConfigurationState;
import javax.validation.spi.ValidationProvider;

/**
 * @author Hardy Ferentschik
 */
public class TCKValidationProvider implements ValidationProvider<TCKValidatorConfiguration> {

	public TCKValidatorConfiguration createSpecializedConfiguration(BootstrapState state) {
		return TCKValidatorConfiguration.class.cast( new TCKValidatorConfiguration( this ) );
	}

	public Configuration<?> createGenericConfiguration(BootstrapState state) {
		return new TCKValidatorConfiguration( this );
	}

	public ValidatorFactory buildValidatorFactory(ConfigurationState configurationState) {
		return new DummyValidatorFactory();
	}

	public static class DummyValidatorFactory implements ValidatorFactory {

		public Validator getValidator() {
			throw new UnsupportedOperationException();
		}

		public ValidatorContext usingContext() {
			throw new UnsupportedOperationException();
		}

		public MessageInterpolator getMessageInterpolator() {
			throw new UnsupportedOperationException();
		}

		public <T> T unwrap(Class<T> type) {
			throw new UnsupportedOperationException();
		}
	}
}
