// $Id: MappingStreamHandlingTest.java 16948 2009-06-25 10:10:13Z hardy.ferentschik $
/*
* JBoss, Home of Professional Open Source
* Copyright 2008, Red Hat Middleware LLC, and individual contributors
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
* http://www.apache.org/licenses/LICENSE-2.0
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
package org.hibernate.jsr303.tck.tests.configuration;

import java.io.IOException;
import java.io.InputStream;
import javax.validation.Configuration;
import javax.validation.Validation;

import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Resource;
import org.jboss.testharness.impl.packaging.Classes;
import static org.testng.Assert.assertTrue;
import static org.testng.FileAssert.fail;
import org.testng.annotations.Test;

import static org.hibernate.jsr303.tck.util.TestUtil.getInputStreamForPath;
import org.hibernate.jsr303.tck.util.TestUtil;

/**
 * @author Hardy Ferentschik
 */
@Artifact(artifactType = ArtifactType.JSR303)
@Resource(source = "empty-constraints.xml",
		destination = "WEB-INF/classes/org/hibernate/jsr303/tck/tests/configuration/empty-constraints.xml")
@Classes({TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class})
public class MappingStreamHandlingTest extends AbstractTest {

	@Test
	@SpecAssertion(section = "4.4.3", id = "b")
	public void testMappingStreamGetsClosed() {
		Configuration<?> config = Validation.byDefaultProvider().configure();
		InputStream in = getInputStreamForPath( "org/hibernate/jsr303/tck/tests/configuration/empty-constraints.xml" );
		DelegatingInputStream delegatingInputStream = new DelegatingInputStream( in );
		config.addMapping( delegatingInputStream );
		config.buildValidatorFactory();

		assertTrue( delegatingInputStream.closeHasBeenCalled, "The input stream must be closed." );
	}

	@Test
	@SpecAssertion(section = "4.4.3", id = "b")
	public void testMappingStreamGetsClosedInExceptionalCondition() {
		Configuration<?> config = Validation.byDefaultProvider().configure();
		DummyInputStream dummyIn = new DummyInputStream();
		config.addMapping( dummyIn );
		try {
			config.buildValidatorFactory();
			fail();
		}
		catch ( Exception e ) {
			// success
		}

		assertTrue( dummyIn.closeHasBeenCalled, "The input stream must be closed." );
	}

	public class DummyInputStream extends InputStream {
		boolean closeHasBeenCalled = false;

		public int read() throws IOException {
			throw new IOException();
		}

		public void close() throws IOException {
			closeHasBeenCalled = true;
			super.close();
		}
	}

	public class DelegatingInputStream extends InputStream {
		boolean closeHasBeenCalled = false;
		final InputStream delegate;

		public DelegatingInputStream(InputStream in) {
			delegate = in;
		}

		public int read() throws IOException {
			return delegate.read();
		}

		public void close() throws IOException {
			closeHasBeenCalled = true;
			delegate.close();
		}
	}
}