// $Id:$
/*
* JBoss, Home of Professional Open Source
* Copyright 2008, Red Hat Middleware LLC, and individual contributors
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
* http://www.apache.org/licenses/LICENSE-2.0
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
package org.hibernate.jsr303.tck.tests.constraints.constraintcomposition.nestedconstraintcomposition;

import java.lang.annotation.Target;
import java.lang.annotation.Retention;
import static java.lang.annotation.RetentionPolicy.RUNTIME;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.FIELD;
import javax.validation.constraints.Pattern;
import javax.validation.Constraint;
import javax.validation.ConstraintPayload;
import javax.validation.ReportAsSingleViolation;

/**
 * @author Hardy Ferentschik
 */
@Pattern(regexp = "abc")
@Target({ METHOD, FIELD })
@Retention(RUNTIME)
@Constraint(validatedBy = { })
@SecondCompositeConstraint
@ReportAsSingleViolation
public @interface FirstCompositeConstraint4 {
	public abstract String message() default "FirstCompositeConstraint4 failed.";

	public abstract Class<?>[] groups() default { };

	public abstract Class<? extends ConstraintPayload>[] payload() default { };
}