// $Id: NestedConstraintCompositionTest.java 17088 2009-07-14 11:45:54Z hardy.ferentschik $
/*
* JBoss, Home of Professional Open Source
* Copyright 2008, Red Hat Middleware LLC, and individual contributors
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
* http://www.apache.org/licenses/LICENSE-2.0
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,  
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
package org.hibernate.jsr303.tck.tests.constraints.constraintcomposition.nestedconstraintcomposition;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.testng.annotations.Test;

import org.hibernate.jsr303.tck.util.TestUtil;
import static org.hibernate.jsr303.tck.util.TestUtil.assertCorrectConstraintTypes;
import static org.hibernate.jsr303.tck.util.TestUtil.assertCorrectConstraintViolationMessages;
import static org.hibernate.jsr303.tck.util.TestUtil.assertCorrectNumberOfViolations;

/**
 * Tests for composing constraints.
 *
 * @author Hardy Ferentschik
 */
@Artifact(artifactType = ArtifactType.JSR303)
@Classes({ TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class })
public class NestedConstraintCompositionTest extends AbstractTest {

	@Test
	public void testFirstConstraintAllViolationsSecondConstraintSingleViolation() {
		Validator validator = TestUtil.getDefaultValidator();
		DummyEntity1 dummy = new DummyEntity1( "" );
		Set<ConstraintViolation<DummyEntity1>> constraintViolations = validator.validate( dummy );
		assertCorrectNumberOfViolations( constraintViolations, 2 );
		assertCorrectConstraintTypes(
				constraintViolations, Pattern.class, SecondCompositeConstraintSingleViolation.class
		);
		assertCorrectConstraintViolationMessages(
				constraintViolations, "Pattern must match abc", "SecondCompositeConstraintSingleViolation failed."
		);
	}

	@Test
	public void testFirstConstraintSingleViolationSecondConstraintSingleViolation() {
		Validator validator = TestUtil.getDefaultValidator();
		DummyEntity2 dummy = new DummyEntity2( "" );
		Set<ConstraintViolation<DummyEntity2>> constraintViolations = validator.validate( dummy );
		assertCorrectNumberOfViolations( constraintViolations, 1 );
		assertCorrectConstraintTypes( constraintViolations, FirstCompositeConstraint2.class );
		assertCorrectConstraintViolationMessages( constraintViolations, "FirstCompositeConstraint2 failed." );
	}

	@Test
	public void testFirstConstraintAllViolationSecondConstraintAllViolations() {
		Validator validator = TestUtil.getDefaultValidator();
		DummyEntity3 dummy = new DummyEntity3( "" );
		Set<ConstraintViolation<DummyEntity3>> constraintViolations = validator.validate( dummy );
		assertCorrectNumberOfViolations( constraintViolations, 3 );
		assertCorrectConstraintTypes( constraintViolations, Pattern.class, Pattern.class, Size.class );
		assertCorrectConstraintViolationMessages(
				constraintViolations, "Pattern must match abc", "Pattern must match ...", "Size must be 3"
		);
	}

	@Test
	public void testFirstConstraintSingleViolationSecondConstraintAllViolations() {
		Validator validator = TestUtil.getDefaultValidator();
		DummyEntity4 dummy = new DummyEntity4( "" );
		Set<ConstraintViolation<DummyEntity4>> constraintViolations = validator.validate( dummy );
		assertCorrectNumberOfViolations( constraintViolations, 1 );
		assertCorrectConstraintTypes( constraintViolations, FirstCompositeConstraint4.class );
		assertCorrectConstraintViolationMessages( constraintViolations, "FirstCompositeConstraint4 failed." );
	}


	class DummyEntity1 {
		@FirstCompositeConstraint1
		String string;

		DummyEntity1(String s) {
			this.string = s;
		}
	}

	class DummyEntity2 {
		@FirstCompositeConstraint2
		String string;

		DummyEntity2(String s) {
			this.string = s;
		}
	}

	class DummyEntity3 {
		@FirstCompositeConstraint3
		String string;

		DummyEntity3(String s) {
			this.string = s;
		}
	}

	class DummyEntity4 {
		@FirstCompositeConstraint4
		String string;

		DummyEntity4(String s) {
			this.string = s;
		}
	}
}