// $Id:$
/*
* JBoss, Home of Professional Open Source
* Copyright 2008, Red Hat Middleware LLC, and individual contributors
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
* http://www.apache.org/licenses/LICENSE-2.0
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
package org.hibernate.jsr303.tck.tests.constraints.groups.groupsequence;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.GroupDefinitionException;
import javax.validation.GroupSequence;
import javax.validation.Validator;
import javax.validation.constraints.Pattern;

import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.testng.annotations.Test;

import org.hibernate.jsr303.tck.util.TestUtil;
import static org.hibernate.jsr303.tck.util.TestUtil.assertCorrectNumberOfViolations;

/**
 * @author Hardy Ferentschik
 */
@Artifact(artifactType = ArtifactType.JSR303)
@Classes({ TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class })
public class SequenceResolutionTest extends AbstractTest {

	@Test(expectedExceptions = GroupDefinitionException.class)
	@SpecAssertions({
			@SpecAssertion(section = "3.4.2", id = "e"),
			@SpecAssertion(section = "3.4.2", id = "f"),
			@SpecAssertion(section = "3.4.2", id = "i"),
			@SpecAssertion(section = "8.4", id = "a")
	})
	public void testInvalidDefinitionOfDefaultSequenceInEntity() {
		Validator validator = TestUtil.getDefaultValidator();
		TestEntity entity = new TestEntity();
		validator.validate( entity, Complete.class );
	}

	@Test(enabled = false)
//	@SpecAssertion(section = "3.4.2", id = "j")
	public void testOnlyFirstGroupInSequenceGetEvaluated() {
		Validator validator = TestUtil.getDefaultValidator();
		Car car = new Car( "USd-298" );
		
		Set<ConstraintViolation<Car>> violations = validator.validateProperty(
				car, "licensePlateNumber", All.class
		);
		assertCorrectNumberOfViolations( violations, 1 );
		ConstraintViolation<Car> violation = violations.iterator().next();
	}

	class Car {
		@Pattern(regexp = "[A-Z][A-Z][A-Z]-[0-9][0-9][0-9]", groups = { First.class, Second.class })
		private String licensePlateNumber;

		Car(String licensePlateNumber) {
			this.licensePlateNumber = licensePlateNumber;
		}

		public String getLicensePlateNumber() {
			return licensePlateNumber;
		}
	}

	interface First {
	}

	interface Second {
	}

	@GroupSequence({ First.class, Second.class })
	interface All {
	}
}
