// $Id: Order.java 16900 2009-06-23 12:56:46Z hardy.ferentschik $
/*
* JBoss, Home of Professional Open Source
* Copyright 2008, Red Hat Middleware LLC, and individual contributors
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
* http://www.apache.org/licenses/LICENSE-2.0
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
package org.hibernate.jsr303.tck.tests.validation.graphnavigation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

/**
 * @author Hardy Ferentschik
 */
public class Order {
	@NotNull
	Integer orderId;

	@Valid
	private List<OrderLine> orderLines = new ArrayList<OrderLine>();

	@Valid
	private User customer;

	@Valid
	private Address shippingAddress;

	@Valid
	private Address billingAddress;

	public Order(Integer id) {
		orderId = id;
	}

	public void addOrderLine(OrderLine orderLine) {
		orderLines.add( orderLine );
	}

	public List<OrderLine> getOrderLines() {
		return Collections.unmodifiableList( orderLines );
	}

	public User getCustomer() {
		return customer;
	}

	public void setCustomer(User customer) {
		this.customer = customer;
	}

	public Address getShippingAddress() {
		return shippingAddress;
	}

	public void setShippingAddress(Address shippingAddress) {
		this.shippingAddress = shippingAddress;
	}

	public Address getBillingAddress() {
		return billingAddress;
	}

	public void setBillingAddress(Address billingAddress) {
		this.billingAddress = billingAddress;
	}

	@Override
	public String toString() {
		return "Order{" +
				"orderId=" + orderId +
				", orderLines=" + orderLines +
				", customer=" + customer +
				", shippingAddress=" + shippingAddress +
				", billingAddress=" + billingAddress +
				'}';
	}
}