// $Id: CustomConstraintValidatorTest.java 16948 2009-06-25 10:10:13Z hardy.ferentschik $
/*
* JBoss, Home of Professional Open Source
* Copyright 2008, Red Hat Middleware LLC, and individual contributors
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
* http://www.apache.org/licenses/LICENSE-2.0
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
package org.hibernate.jsr303.tck.tests.validatorfactory;

import javax.validation.Configuration;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;

import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import static org.testng.Assert.assertTrue;
import org.testng.annotations.Test;

import org.hibernate.jsr303.tck.util.TestUtil;

/**
 * @author Hardy Ferentschik
 */
@Artifact(artifactType = ArtifactType.JSR303)
@Classes({TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class})
public class CustomConstraintValidatorTest extends AbstractTest {

	@SpecAssertion(section = "2.5", id = "a")
	@Test
	public void testDefaultConstructorInValidatorCalled() {
		Validator validator = TestUtil.getDefaultValidator();
		validator.validate( new Dummy() );
		assertTrue(
				MyConstraintValidator.defaultConstructorCalled,
				"The no-arg default constructor should have been called."
		);
	}

	@SpecAssertion(section = "2.5", id = "b")
	@Test(expectedExceptions = ValidationException.class)
	public void testRuntimeExceptionInValidatorCreationIsWrapped() {
		Validator validator = TestUtil.getDefaultValidator();
		validator.validate( new SecondDummy() );
	}

	@SpecAssertion(section = "2.5", id = "c")
	@Test(expectedExceptions = ValidationException.class)
	public void testValidationExceptionIsThrownInCaseFactoryReturnsNull() {
		// cast is required for JDK 5 - at least on Mac OS X
		Configuration<?> config = (Configuration<?>) Validation.byDefaultProvider().configure().constraintValidatorFactory(
				new ConstraintValidatorFactory() {
					public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> key) {
						return null;
					}
				}
		);
		Validator validator = config.buildValidatorFactory().getValidator();
		validator.validate( new SecondDummy() );
	}

	public static class Dummy {
		@MyConstraint
		public int value;
	}

	public static class SecondDummy {
		@MySecondConstraint
		public int value;
	}
}