/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.bootstrap;

import java.util.Locale;
import java.util.Set;
import javax.validation.Configuration;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.jsr303.tck.common.TCKValidationProvider;
import org.hibernate.jsr303.tck.common.TCKValidatorConfiguration;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.testng.Assert;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class, TCKValidationProvider.class, TCKValidatorConfiguration.class, TCKValidationProvider.DummyValidatorFactory.class})
public class CustomMessageInterpolatorTest
extends AbstractTest {
    @Test
    @SpecAssertion(section="4.3.2", id="b")
    public void testCustomMessageInterpolatorViaConfiguration() {
        Configuration config = Validation.byDefaultProvider().configure();
        config = config.messageInterpolator((MessageInterpolator)new DummyMessageInterpolator());
        Validator validator = config.buildValidatorFactory().getValidator();
        this.assertCustomMessageInterpolatorUsed(validator);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.4.2", id="a"), @SpecAssertion(section="4.4.2", id="b"), @SpecAssertion(section="4.3.2", id="b")})
    public void testCustomMessageInterpolatorViaValidatorContext() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        DummyMessageInterpolator dummyMessageInterpolator = new DummyMessageInterpolator();
        Validator validator = factory.usingContext().messageInterpolator((MessageInterpolator)dummyMessageInterpolator).getValidator();
        this.assertCustomMessageInterpolatorUsed(validator);
        Assert.assertFalse((boolean)factory.getMessageInterpolator().equals(dummyMessageInterpolator), (String)"getMessageInterpolator() should return the default message interpolator.");
    }

    private void assertCustomMessageInterpolatorUsed(Validator validator) {
        Person person = new Person();
        person.setFirstName("John");
        person.setPersonalNumber(1234567890L);
        Set constraintViolations = validator.validate((Object)person, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(constraintViolations, "my custom message");
    }

    public class Person {
        @NotNull
        private String firstName;
        @NotNull
        private String lastName;
        @Digits(integer=10, fraction=0)
        private long personalNumber;

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public long getPersonalNumber() {
            return this.personalNumber;
        }

        public void setPersonalNumber(long personalNumber) {
            this.personalNumber = personalNumber;
        }
    }

    private static class DummyMessageInterpolator
    implements MessageInterpolator {
        private DummyMessageInterpolator() {
        }

        public String interpolate(String message, MessageInterpolator.Context context) {
            return "my custom message";
        }

        public String interpolate(String message, MessageInterpolator.Context context, Locale locale) {
            throw new UnsupportedOperationException("No specific locale is possible");
        }
    }
}

