/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.bootstrap;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Configuration;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.ValidationProviderResolver;
import javax.validation.ValidatorFactory;
import javax.validation.spi.ValidationProvider;
import org.hibernate.jsr303.tck.common.TCKValidationProvider;
import org.hibernate.jsr303.tck.common.TCKValidatorConfiguration;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.testng.Assert;
import org.testng.FileAssert;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class, TCKValidationProvider.class, TCKValidationProvider.DummyValidatorFactory.class, TCKValidatorConfiguration.class})
public class ValidationProviderTest
extends AbstractTest {
    @Test
    @SpecAssertion(section="4.4.4.2", id="b")
    public void testFirstMatchingValidationProviderResolverIsReturned() {
        ValidationProviderResolver resolver = new ValidationProviderResolver(){

            public List<ValidationProvider<?>> getValidationProviders() {
                ArrayList list = new ArrayList();
                list.add(TestUtil.getValidationProviderUnderTest());
                list.add(new TCKValidationProvider());
                return list;
            }
        };
        Configuration configuration = Validation.byProvider(TCKValidationProvider.class).providerResolver(resolver).configure();
        ValidatorFactory factory = configuration.buildValidatorFactory();
        Assert.assertTrue((boolean)(factory instanceof TCKValidationProvider.DummyValidatorFactory));
    }

    @Test
    @SpecAssertion(section="4.4.4.2", id="c")
    public void testByDefaultProviderUsesTheFirstProviderReturnedByValidationProviderResolver() {
        ValidationProviderResolver resolver = new ValidationProviderResolver(){

            public List<ValidationProvider<?>> getValidationProviders() {
                ArrayList list = new ArrayList();
                list.add(new TCKValidationProvider());
                list.add(TestUtil.getValidationProviderUnderTest());
                return list;
            }
        };
        Configuration configuration = Validation.byDefaultProvider().providerResolver(resolver).configure();
        ValidatorFactory factory = configuration.buildValidatorFactory();
        Assert.assertTrue((boolean)(factory instanceof TCKValidationProvider.DummyValidatorFactory));
    }

    @Test
    @SpecAssertion(section="4.4.4.2", id="d")
    public void testValidationProviderContainsNoArgConstructor() {
        ValidationProvider<?> validationProviderUnderTest = TestUtil.getValidationProviderUnderTest();
        try {
            Constructor<?> constructor = validationProviderUnderTest.getClass().getConstructor(new Class[0]);
            Assert.assertTrue((boolean)Modifier.isPublic(constructor.getModifiers()));
        }
        catch (Exception e) {
            FileAssert.fail((String)"The validation provider must have a public no arg constructor");
        }
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertions(value={@SpecAssertion(section="4.4.5", id="f"), @SpecAssertion(section="4.4.4.2", id="e")})
    public void testValidationExceptionIsThrownInCaseValidatorFactoryCreationFails() {
        ValidationProviderResolver resolver = new ValidationProviderResolver(){

            public List<ValidationProvider<?>> getValidationProviders() {
                throw new RuntimeException("ValidationProviderResolver failed!");
            }
        };
        Validation.byDefaultProvider().providerResolver(resolver).configure();
    }
}

