/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.bootstrap.customprovider;

import javax.validation.Configuration;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.hibernate.jsr303.tck.common.TCKValidationProvider;
import org.hibernate.jsr303.tck.common.TCKValidatorConfiguration;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.jboss.testharness.impl.packaging.IntegrationTest;
import org.jboss.testharness.impl.packaging.Resource;
import org.testng.Assert;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class, TCKValidationProvider.class, TCKValidatorConfiguration.class, TCKValidationProvider.DummyValidatorFactory.class})
@Resource(source="javax.validation.spi.ValidationProvider", destination="WEB-INF/classes/META-INF/services/javax.validation.spi.ValidationProvider")
@IntegrationTest
public class BootstrapCustomProviderDefinedInServiceFileTest
extends AbstractTest {
    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.4", id="a"), @SpecAssertion(section="4.4.4.2", id="a")})
    public void testGetFactoryByProviderSpecifiedProgrammatically() {
        TCKValidatorConfiguration configuration = (TCKValidatorConfiguration)Validation.byProvider(TCKValidationProvider.class).configure();
        ValidatorFactory factory = configuration.buildValidatorFactory();
        Assert.assertNotNull((Object)factory);
        Assert.assertTrue((boolean)(factory instanceof TCKValidationProvider.DummyValidatorFactory));
    }

    @Test
    @SpecAssertion(section="4.4.4.1", id="a")
    public void testProviderResolverReturnsListOfAvailableProviders() {
        TCKValidatorConfiguration configuration = (TCKValidatorConfiguration)Validation.byProvider(TCKValidationProvider.class).configure();
        ValidatorFactory factory = configuration.buildValidatorFactory();
        Assert.assertNotNull((Object)factory);
        Configuration config = Validation.byProvider(TestUtil.getValidationProviderUnderTest().getClass()).configure();
        factory = config.buildValidatorFactory();
        Assert.assertNotNull((Object)factory);
    }
}

