/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jsr303.tck.tests.constraints.application;

import java.util.Set;
import javax.validation.Validator;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.jsr303.tck.tests.constraints.application.Building;
import org.hibernate.jsr303.tck.tests.constraints.application.DummyGroup;
import org.hibernate.jsr303.tck.tests.constraints.application.SecurityCheck;
import org.hibernate.jsr303.tck.tests.constraints.application.SuperWoman;
import org.hibernate.jsr303.tck.tests.constraints.application.TightSecurity;
import org.hibernate.jsr303.tck.tests.constraints.application.Visibility;
import org.hibernate.jsr303.tck.tests.constraints.application.Woman;
import org.hibernate.jsr303.tck.util.TestUtil;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.testng.annotations.Test;

@Artifact(artifactType=ArtifactType.JSR303)
@Classes(value={TestUtil.class, TestUtil.PathImpl.class, TestUtil.NodeImpl.class})
public class ValidationRequirementTest
extends AbstractTest {
    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.1", id="c"), @SpecAssertion(section="3.1", id="d"), @SpecAssertion(section="3.1.1", id="a")})
    public void testClassLevelConstraints() {
        Woman sarah = new Woman();
        sarah.setFirstName("Sarah");
        sarah.setLastName("Jones");
        sarah.setPersonalNumber("000000-0000");
        Validator validator = TestUtil.getValidatorUnderTest();
        Set violations = validator.validate((Object)sarah, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintTypes(violations, SecurityCheck.class);
        violations = validator.validate((Object)sarah, new Class[]{TightSecurity.class});
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintTypes(violations, SecurityCheck.class);
        violations = validator.validate((Object)sarah, new Class[]{DummyGroup.class});
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
        sarah.setPersonalNumber("740523-1234");
        violations = validator.validate((Object)sarah, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
        violations = validator.validate((Object)sarah, new Class[]{TightSecurity.class});
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.1", id="d"), @SpecAssertion(section="3.1.2", id="a"), @SpecAssertion(section="3.1.2", id="c")})
    public void testFieldAccess() {
        SuperWoman superwoman = new SuperWoman();
        Validator validator = TestUtil.getValidatorUnderTest();
        Set violations = validator.validateProperty((Object)superwoman, "firstName", new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
        superwoman.setFirstName(null);
        violations = validator.validateProperty((Object)superwoman, "firstName", new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.1", id="d"), @SpecAssertion(section="3.1.2", id="a"), @SpecAssertion(section="3.1.2", id="d")})
    public void testPropertyAccess() {
        SuperWoman superwoman = new SuperWoman();
        Validator validator = TestUtil.getValidatorUnderTest();
        Set violations = validator.validateProperty((Object)superwoman, "lastName", new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
        superwoman.setHiddenName(null);
        violations = validator.validateProperty((Object)superwoman, "lastName", new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintTypes(violations, NotNull.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.1.2", id="a"), @SpecAssertion(section="3.1.2", id="b")})
    public void testConstraintAppliedOnFieldAndProperty() {
        Building building = new Building(10000000L);
        Validator validator = TestUtil.getValidatorUnderTest();
        Set violations = validator.validate((Object)building, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 2);
        String expectedMessage = "Building costs are max {max} dollars.";
        TestUtil.assertCorrectConstraintViolationMessages(violations, expectedMessage, expectedMessage);
    }

    @Test(enabled=false)
    public void testIgnoreStaticFieldsAndProperties() {
        StaticFieldsAndProperties entity = new StaticFieldsAndProperties();
        Validator validator = TestUtil.getValidatorUnderTest();
        Set violations = validator.validate((Object)entity, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
    }

    @Test
    @SpecAssertion(section="3.1.2", id="e")
    public void testFieldAndPropertyVisibilityIsNotConstrained() {
        Visibility entity = new Visibility();
        Validator validator = TestUtil.getValidatorUnderTest();
        Set violations = validator.validate((Object)entity, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 6);
        TestUtil.assertCorrectConstraintTypes(violations, Min.class, Min.class, Min.class, DecimalMin.class, DecimalMin.class, DecimalMin.class);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "publicField", "protectedField", "privateField", "publicProperty", "protectedProperty", "privateProperty");
        entity.setValues(100);
        violations = validator.validate((Object)entity, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
    }

    static class StaticFieldsAndProperties {
        @NotNull
        static Object staticField = null;

        StaticFieldsAndProperties() {
        }

        @NotNull
        static Object getStaticProperty() {
            return null;
        }
    }
}

